/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_MANGLE_DEMANGLE_HPP
#define SL_MANGLE_DEMANGLE_HPP

#include <string>
#include <sl/config.hpp>

namespace sl {

/**
 * ̾Υǥޥ󥰥.
 *
 * object 饹 to_stringдؿ(JavaObject.toString())
 * ¸뤿˻Ѥ.
 * to_string(toString)νޤ狼äƤʤΤ
 * ľưʤƤɤǤ.
 *
 * @param typeid Ǽ̾ʸ.
 * @return ǥޥ󥰥η̾(cxxapi.hʤϥǥޥ󥰥뤷ʤ).
 */
inline std::string demangle(const std::string& s)
{
#if defined(SL_CXXABI_DEMANGLE)
    int i;
    const char* p = abi::__cxa_demangle(s.c_str(), 0, 0, &i);
    if (i == 0)
        return std::string(p);
    throw std::invalid_argument(
          std::string("demangle failed. invalid type name:") + s);
#else
    throw std::runtime_error("sl::demangle failed. "
                             "C++ ABI(SL_CXXABI_DEMANGLE) is not defined.");
#endif
}

} // namespace sl

#endif // SI_MANGLE_DEMANGLE_HPP
