/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: object.cpp,v 1.8 2007/09/02 14:08:28 cvsuser Exp $
 */
#include <iostream>
#include <fstream>
#include <map>
#include <string>
#include <boost/archive/text_oarchive.hpp>
#include <boost/archive/text_iarchive.hpp>
using namespace std;
using namespace boost;


#include <java/lang/Object.h>
#include <java/lang/Integer.h>
#include <java/lang/String.h>
using namespace java::lang;

#include <sl/object.h>

#if 1
class TestType1 : public objectable {
public :
	TestType1() : _value("TestType1") { }

	virtual ~TestType1() { }

	virtual void print() { cout << _value << endl; }

	void set(const string &value) { _value = value; }

	const string &get() { return _value; }

private :
	string		_value;
};


class TestType2 : public TestType1 {
public :
	TestType2()
	{
		set("TestType2");
	}

private :
#if 0
	friend class boost::serialization::access;

	template<class Archive>
    void serialize(Archive & ar, const unsigned int file_version)
	{
		ar & get();
	}
#endif
};

//BOOST_CLASS_EXPORT_GUID(TestType2, "TestType2");

struct TestType3 {
	virtual void print() { cout << "TestType3" << endl; }
};

#endif


#if 1
void test_1()
{
	cout << "ƥ:" << __FUNCTION__ << endl;

	String sp("java::lang::String");

	Object o1;
	Object o2(new Integer(100));
	Object o3(new String("const char *"));
	Object o4(new objectable_type<string>("string"));
	Object o5(new String(sp));

	map<string, string> m;
	m.insert(make_pair("name", "value"));
	Object o6(new objectable_type<map<string, string> >(m));

	cout << "String sp(\"java::lang::String\")" << endl;
	cout << "Object o1" << endl;
	cout << "Object o2(new Integer(100))" << endl;
	cout << "Object o3(new String(\"const char *\"))" << endl;
	cout << "Object o4(new objectable_type<string>(\"string\"))" << endl;
	cout << "Object o5(new String(sp))" << endl;
	cout << "Object o6(new map<string, string> >(m))" << endl;

	if (o1)
		cout << "if (o1)  true֤ޤ." << endl;
	else
		cout << "if (o1)  false֤ޤ." << endl;

	if (o2)
		cout << "if (o2)  true֤ޤ." << endl;
	else
		cout << "if (o2)  false֤ޤ." << endl;

	if (o3)
		cout << "if (o3)  true֤ޤ." << endl;
	else
		cout << "if (o3)  false֤ޤ." << endl;

	if (!o1)
		cout << "if (!o1) true֤ޤ." << endl;
	else
		cout << "if (!o1) false֤ޤ." << endl;

	if (!o2)
		cout << "if (!o2) true֤ޤ." << endl;
	else
		cout << "if (!o2) false֤ޤ." << endl;

	if (!o3)
		cout << "if (!o3) true֤ޤ." << endl;
	else
		cout << "if (!o3) false֤ޤ." << endl;

	// o2(Integer)  int ǥ㥹.
	int i = object_cast<int>(o2);
	cerr << "o2  int ǥ㥹:" << i << endl;

	// o3(const char*)  String ǥ㥹.
	string c = sl::object_cast<String>(o3);
	cerr << "o3  String ǥ㥹:" << c << endl;

	// o3(const char*)  string ǥ㥹.
	c = object_cast<string>(o3);
	cerr << "o3  string ǥ㥹:" << c << endl;

	// o4(objectable_type<string>("string"))  string ǥ㥹.
	string s = object_cast<string>(o4);
	cerr << "o4  string ǥ㥹:" << s << endl;

	// o5(String)  String ǥ㥹.
	String ss = object_cast<String>(o5);
	cerr << "o5  String ǥ㥹:" << ss << endl;

	map<string, string> mp = object_cast<map<string, string> >(o6);
	cerr << "o6  map<string, string> ǥ㥹:" << mp.size() << endl;

}
#endif


#if 1
void test_2()
{
	cout << "ƥ:" << __FUNCTION__ << endl;

	Object obj(new TestType1());

	cout << "Object obj(new TestType1())" << endl;;

	try {
		// obj(TestType1)TestType2إ㥹ȤƤߤ.
		object_cast<TestType2>(obj).print();
	} catch(bad_cast) {
		cout << "obj(TestType1)  TestType2 ؤΥ㥹ȤϼԤޤ" << endl;
	}

	try {
		// obj(TestType1)TestType3إ㥹ȤƤߤ.
		forcible_cast<TestType3>(obj).print();
	} catch(bad_cast) {
		cout << "obj(TestType1)  TestType3 ؤΥ㥹ȤϼԤޤ"
			 << endl;
	}

	Object obj2(new TestType2());

	cout << "Object obj(new TestType2())" << endl;;

	try {
		// obj2(TestType2)TestType1˥㥹Ȥƴؿ򥳡.
		object_cast<TestType1>(obj2).print();
		object_cast<TestType1>(obj2).set("SET METHOD CALLED");
	} catch(bad_cast) {
		cout << "obj2(TestType2)  TestType1 ؤΥ㥹ȤϼԤޤ"
			 << endl;
	}

	try {
		// obj2(TestType2)TestType2˥㥹Ȥƴؿ򥳡.
		object_cast<TestType2>(obj2).print();
	} catch(bad_cast) {
		cout << "obj2(TestType2)  TestType2 ؤΥ㥹ȤϼԤޤ"
			 << endl;
	}

	// String::valueOf ŬѤƤߤ.
	String value = String::valueOf(obj2);
	cout << "String::valueOf(obj2) : " << value << endl;
}
#endif 


#if 1
void test_3()
{
	cout << "ƥ:" << __FUNCTION__ << endl;

	Object obj(new TestType2());

	// ֥ȤΥԡ󥹥ȥ饯.
	Object obj2(obj);

	// ̾Υ㥹Ȥ.
	TestType1 &t1 = object_cast<TestType1>(obj);
	cout << "̾Υ㥹Ȥ:";
    t1.print();

	// ԡ.
	Object obj3 = obj2;

	// ԡλɽ.
	TestType1 &tt = object_cast<TestType1>(obj3);
	cout << "ԡ褫黲ɽ:";
    tt.print();
}
#endif 


#if 1
void test_4()
{
	cout << "ƥ:" << __FUNCTION__ << endl;

	const string s1("const string *"); // ꡼뤫
	string s2("const string *");
	const string s3("const string *");
	string s4("const string *");

	Object o1(new String(s1));
	Object o2(new String(s2));
	Object o3(new String(s3));
	Object o4(new String(s4));
}
#endif 

void test1();
void test2(Object& obj);

void test1()
{
	cout << __FUNCTION__ << endl;

	Object obj1;
	Object obj2(new objectable_type<int>(100));

	if (obj1) {
		cout << "obj1 is not null" << endl;
		test2(obj1);
	} else {
		cout << "obj1 is null" << endl;
	}

	if (obj2) {
		cout << "obj2 is not null" << endl;
		test2(obj2);
	} else {
		cout << "obj2 is null" << endl;
	}
}

void test2(Object &obj)
{
	cout << __FUNCTION__ << endl;

	// ֥Ȥμ֤򻲾ȤǼФ.
	int &i = object_cast<objectable_type<int> >(obj);
	cout << "Objectλ :" << i << endl;

	// ֥Ȥμ֤ + 100 Ƥߤ.
	i += 100;

	// ֥Ȥμ֤ΥԡФ.
	int j = object_cast<objectable_type<int> >(obj);
	cout << "100ûObjectλΥԡ :" << j << endl;
}

int main()
{
	test1();

	Object obj1;

	String s("TEST");
	String value = String::valueOf(99.99);
	cout << value << endl;
	value = String::valueOf(obj1);
	cout << value << endl;

	String sample("null");
	cout << sample.compareTo(value) << endl;

//	for (;;) {
		test_1();
		test_2();
		test_3();
		test_4();
//	}

	return 0;
}
