/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: class_loader.cpp,v 1.2 2007/09/02 14:08:28 cvsuser Exp $
 */
#include "ClassLoader.h"
#include "Class.h"
using namespace java::lang;

//#include "Base.h"
#include "Target.h"

class simple_class_loader : public ClassLoader {
public :
	Class loadClass(const std::string &file)
		throw (java::lang::ClassNotFoundException)
	{
		return ClassLoader::findSystemClass(file);
	}
};

int main()
{
	simple_class_loader loader;

	Class clazz = loader.loadClass("./Target");

	boost::shared_ptr<Test::Base> obj = clazz.newInstance<Test::Base>();
	std::cerr << obj->member_function() << std::endl;

#if 0
	Class clazz2 = loader.loadClass("./Target");

	Object obj2 = clazz2.newInstance<Test::Target>();
	std::cerr << object_cast<Test::Target>(obj2).member_function()
			  << std::endl;
#endif
	return 0;
}
