/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_LANG_NUMBER_H
#define JAVA_LANG_NUMBER_H

#include <iostream>
#include <stdexcept>
#include <string>

#include <sl/java/lang/Object.h>

namespace sl {
namespace java {
namespace lang { 

class Number : virtual public objectable {
public :
    Number() { }

    ~Number() { }

    // Returns the value of the specified number as a byte. 
    virtual unsigned char byteValue()=0;

    // Returns the value of the specified number as a short. 
    virtual short shortValue()=0;

    // Returns the value of the specified number as an int. 
    virtual int intValue()=0;

    // Returns the value of the specified number as a long. 
    virtual long longValue()=0;

    // Returns the value of the specified number as a float. 
    virtual float floatValue()=0;

    // Returns the value of the specified number as a double. 
    virtual double doubleValue()=0;
};

} // namespace lang
} // namespace java
} // namespace sl

#endif // JAVA_LANG_NUMBER_H
