/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_LANG_INTEGER_H
#define JAVA_LANG_INTEGER_H

#include <iostream>
#include <sstream>
#include <stdexcept>
#include <string>

#include <sl/java/lang/Exception.h>
#include <sl/java/lang/Number.h>

namespace sl {
namespace java {
namespace lang { 

class Integer : virtual public Number {
public :
    Integer() { }

    Integer(int i) : _integer(i) { }
#if 0
    Integer(const Integer &i)
    {
        _integer = i._integer;
    }
#endif
    operator int&()
    {
        return _integer;
    }

    // override pure virtual function.
    unsigned char byteValue()
    {
        return static_cast<unsigned char>(_integer);
    }

    // override pure virtual function.
    short shortValue()
    {
        return static_cast<short>(_integer);
    }

    // override pure virtual function.
    int intValue()
    {
        return static_cast<int>(_integer);
    }

    // override pure virtual function.
    long longValue()
    {
        return static_cast<long>(_integer);
    }

    // override pure virtual function.
    float floatValue()
    {
        return static_cast<float>(_integer);
    }

    // override pure virtual function.
    double doubleValue()
    {
        return static_cast<double>(_integer);
    }

    template <typename ValueType>
    static Integer valueOf(ValueType target) throw (Exception)
    {
        try {
            Integer i;
            std::stringstream ss;
            ss << target;
            ss >> i;
            return i;
        } catch (std::bad_cast) {
            throw Exception("");
        }
    }

private :
    int _integer;
};

inline std::ostream &operator<<(std::ostream &os, Integer &s)
{
    return os << static_cast<int &>(s);
}

inline std::istream &operator>>(std::istream &is, Integer &s)
{
    return is >> static_cast<int &>(s);
}

} // namespace lang
} // namespace java
} // namespace sl


#endif // JAVA_LANG_INTEGER_H
