/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_IO_WRITER_H
#define JAVA_IO_WRITER_H

#include <stdexcept>
#include <string>
#include <vector>

namespace sl {
namespace java {
namespace io {

class Writer {
public :

    Writer()
    { }

    virtual ~Writer()
    { }

    void close()
    { }

    void flush()
    { }

    virtual void write(int c)
    {
        char ch = c;
        this->write(&ch, 0, 1);
    }

    virtual void write(const std::string& s)
    {
        this->write(s, 0, s.size());
    }

    virtual void write(const std::string &s, int off, int len)
    {
        this->write(std::vector<char>(s.begin(), s.end()), off, len);
    }

    virtual void write(const std::vector<char>& s)
    {
        this->write(s, 0, s.size());
    }

    virtual void write(const std::vector<char>& s, int off, int len)=0;

    virtual operator std::ostream& ()
    {
        throw std::runtime_error("Writer::op std::ostream&");
    }
};

} // namespace io
} // namespace java
} // namespace sl


#endif // JAVA_IO_WRITER_H
