/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_IO_READER_H
#define JAVA_IO_READER_H

#include <iostream>
#include <stdexcept>
#include <string>
#include <vector>

namespace sl {
namespace java {
namespace io {

class Reader {
public :

    virtual ~Reader() { }

    virtual int available() const
    {
        return 0;
    }

    virtual void close()
    { }

    virtual void mark(int)
    { }

    virtual bool markSupported()
    {
        return true;
    }

    virtual int read()=0;

    virtual int read(std::vector<char>& b, int off, int len)
    {
        skip(off);

        while (len--) {
            int n = read();
            if (n == std::istream::traits_type::eof())
                break;
            b.push_back(static_cast<char>(n));
        }
        return b.size();
    }


    virtual bool ready()
    {
        return true;
    }

    virtual void reset()
    { }

    virtual long skip(long n)
    {
        return n;
    }

    virtual operator std::istream& ()
    {
        throw std::runtime_error("Reader::op std::istream&");
    }

protected :
    Reader() { }
};

} // namespace io
} // namespace java
} // namespace sl


#endif // JAVA_IO_READER_H
