/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_IO_PRINT_WRITER_H
#define JAVA_IO_PRINT_WRITER_H

#include <iostream>
#include <sstream>
#include <string>
#include <sl/java/io/Writer.h>

namespace sl {
namespace java {
namespace io {

class PrintWriter : public Writer {
public :
    PrintWriter(Writer* o, bool auto_flush=false)
        : out(o), flush(auto_flush)
    { }

    template <typename ValueType>
    void print(ValueType x)
    {
        std::stringstream ss;
        ss << x;
        out->write(ss.str());
    }

    void print(const char* s)
    {
        out->write(s);
    }

    void print(const std::string& s)
    {
        out->write(s);
    }

    void print(bool x)
    {
        out->write(x ? "true" : "false");
    }

    template <typename ValueType>
    void println(ValueType x)
    {
        this->print(x);
        this->print("\r\n");
    }

    void println()
    {
        this->print("\r\n");
    } 

    virtual void write(const std::vector<char>& s)
    {
        out->write(s, 0, s.size());
    }

    virtual void write(const std::vector<char>& s, int off, int len)
    {
        out->write(s, off, len);
    }

    virtual operator std::ostream& ()
    {
        return out->operator std::ostream&();
    }

protected :

    void setError() { }

    Writer* out;
    bool flush;
};

} // namespace io
} // namespace java
} // namespace sl


#endif // JAVA_IO_PRINT_WRITER_H
