/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_IO_INPUT_STREAM_H
#define JAVA_IO_INPUT_STREAM_H

#include <iostream>
#include <string>
#include <vector>

namespace sl {
namespace java {
namespace io {

class InputStream {
public :

    InputStream() { }

    InputStream(std::istream* in) : _istream(in) { }

    virtual ~InputStream() { }

    virtual int available() const
    {
        return 0;
    }

    virtual void close()
    { }

    virtual void mark(int)
    {
        _mark = _istream->tellg();
    }

    virtual bool markSupported()
    {
        return true;
    }

    virtual int read()=0;

    virtual int read(std::vector<unsigned char>& b, int off, int len)
    {
        skip(off);

        while (len--) {
            int n = this->read();
            if (n == std::istream::traits_type::eof())
                break;
            b.push_back(static_cast<char>(n));
        }
        return b.size();
    }

    virtual void reset()
    {
        _istream->seekg(_mark);
    }

    virtual long skip(long n)
    {
        _istream->seekg(n, std::ios_base::beg);
        return n;
    }

    operator std::istream& ()
    {
        return *_istream;
    }

protected :
    std::istream* _istream;
    std::istream::pos_type _mark;
};

} // namespace io
} // namespace java
} // namespace sl


#endif // JAVA_IO_INPUT_STREAM_H
