/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef JAVA_IO_BUFFERED_READER_H
#define JAVA_IO_BUFFERED_READER_H

#include <iostream>
#include <string>
#include <sl/java/lang/String.h>
#include <sl/java/io/Reader.h>

namespace sl {
namespace java {
namespace io {

class BufferedReader : public Reader {
public :
    BufferedReader(Reader* i, int sz=-1)
        : in(i), size(sz)
    { }

    ~BufferedReader() { }

    virtual int read()
    {
        return in->read();
    }

    virtual int read(std::vector<char>& b, int off, int len)
    {
        skip(off);

        int i;
        for (i = 0; i < len; i++) {
            int c = this->read();
            if (c == std::istream::traits_type::eof())
                break;
            b.push_back(static_cast<char>(c));
        }
        return i != 0 ? static_cast<int>(b.size()) : -1;
    }

    java::lang::String readLine()
    {
        std::string s;

        for (;;) {
            int n = this->read();
            if (n == '\n') {
                if (!s.empty() && s[s.length() - 1] == '\r')
                    s.erase(s.length() - 1);
                return s;
            }
            if (n == std::istream::traits_type::eof())
                return s.size() ? s : "null";

            s.push_back(static_cast<char>(n));
        }
    }

    virtual operator std::istream& ()
    {
        return in->operator std::istream&();
    }

private :
    Reader* in;
    size_t size;
};

} // namespace io
} // namespace java
} // namespace sl


#endif // JAVA_IO_BUFFERED_READER_H
