#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>

#include <cerrno>
#include <csignal>
#include <iostream>
#include <stdexcept>
#include <vector>
#include <string>
using namespace std;

#include "fdstream.h"

int			_socket;
sockaddr_in _addr;
socklen_t   _addr_length;

#define	PORT	8080

int init()
{
	struct sockaddr_in  saddr;
	if ((_socket = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		throw std::runtime_error(
						string("The error occurred by 'socket' function. ") +
						strerror(errno));

	int flag = 1;
	setsockopt(_socket, SOL_SOCKET, SO_REUSEADDR, &flag, sizeof(flag));
	setsockopt(_socket, IPPROTO_TCP, TCP_NODELAY, &flag, sizeof(flag));


	memset((char *)&saddr, 0x00, sizeof(saddr));

	saddr.sin_family = AF_INET;
	saddr.sin_addr.s_addr = INADDR_ANY;
	saddr.sin_port = htons(PORT);

	if (::bind(_socket, (struct sockaddr *)&saddr, sizeof(saddr)) < 0)
		throw std::runtime_error(string("The error occurred by 'bind' "
								 "function. ") + strerror(errno));

	if (listen(_socket, 128) < 0)
		throw std::runtime_error(string("The error occurred by 'listen' "
								 "function. ") + strerror(errno));

	_addr_length = sizeof(_addr);

	return _socket;
}

int wait_accept()
{
	int s = ::accept(_socket, (struct sockaddr *)&_addr, &_addr_length);
	return s;
}

void handler(int sig)
{
	std::cerr << sig << std::endl;
}

int reader(int fd, char *s, size_t n)
{
std::cerr << "call reader." << std::endl;
	return ::read(fd, s, n);
}

int writer(int fd, char *s, size_t n)
{
std::cerr << "call writer." << std::endl;
	return ::write(fd, s, n);
}

typedef istreambuf_iterator<char> ifs_iterator;


std::string& erase_crlf(std::string& s)
{
	size_t end_offset = (!s.empty() && s[s.length() - 1] == '\0') ? 2 : 1;

	for (;;) {
		if (!s.empty() && s[s.length() - end_offset] == '\n' ||
						  s[s.length() - end_offset] == '\r')
		{
			s.erase(s.length() - end_offset, 1);
		} else
			break;
	}
	return s;
}

void read_line(io::ifdstream& ifs, std::string& s)
{
std::cerr << __FUNCTION__ << std::endl;

	istreambuf_iterator<char> begin(ifs);
	istreambuf_iterator<char> end;

	while (!begin.equal(end)) {
		if (*begin == '\n') {
			begin++;
			break;
		}
		s.append(1, *begin++);
	}
	erase_crlf(s);
	//if (!s.empty() && s[s.length() - 1] == '\r')
	//	s.erase(s.length() - 1);
}

void read_line(io::iofdstream& ifs, std::string& s)
{
std::cerr << __FUNCTION__ << std::endl;

	istreambuf_iterator<char> begin(ifs);
	istreambuf_iterator<char> end;

	while (!begin.equal(end)) {
		if (*begin == '\n') {
			begin++;
			break;
		}
		s.append(1, *begin++);
	}
	erase_crlf(s);
}

int main()
{
	::signal(SIGPIPE, handler);

	init();

	int fd = wait_accept();
	io::iofdstream iofs(fd);

	io::ifdstream ifs(fd);
	ifs.reading_method(&reader);

	io::ofdstream ofs(fd);
	ofs.writing_method(&writer);

	while(ifs.good()) {

std::cerr << "START :" << iofs.rdstate() << std::endl;
std::cerr << "ifs.good():" << ifs.good() << std::endl;
std::cerr << "ifs.eof():" << ifs.eof() << std::endl;
std::cerr << "ifs.fail():" << ifs.fail() << std::endl;

#if 0
		while (ifs.good() && !ifs.eof()) {
			std::string s;
			read_line(ifs, s);

			cerr << "s:[" << s << "]" << endl;
			if (s.empty())
				break;
		}
#endif

#if 0
		istreambuf_iterator<char> begin(ifs);
		std::string s;
		while (!begin.equal(end)) {
			read_line(begin, s, '\n');
			cerr << "s:[" << s << "]" << endl;

			if (!s.empty() && s[s.length() - 1] == '\r')
				s.erase(s.length() - 1);
			if (s.empty())
				break;
			s.clear();
		}
#endif

#if 1
		ifs.rlength(10);
		istreambuf_iterator<char> ite(ifs);
		istreambuf_iterator<char> end;
		while (!ite.equal(end))
			cerr << *ite++;
#endif

#if 0
		std::string s;
		vector<char>	buf(1024);
		while (ifs.good()) {

			ifs.getline(&buf[0], buf.size());
			s.assign(buf.begin(), buf.begin() + ifs.gcount());
			erase_crlf(s);

			std::cerr << "line at [" << &s[0] << "]" << std::endl;
			std::cerr << "size of [" << ifs.gcount() << "]" << std::endl;

			if (s.empty())
				break;

std::cerr << "good():" << ifs.good() << std::endl;
std::cerr << "eof() :" << ifs.eof() << std::endl;
		}
#endif

std::cerr << "END" << std::endl;

#if 1
		if (ofs.good()) {
			ofs << "HTTP/1.0 200 OK\r\n";
			ofs << "Content-Length: 30\r\n";
			ofs << "Connection: Keep-Alive\r\n";
			ofs << "\r\n";
			ofs << "<html><body>TEST</body></html>";
			ofs.flush();
		} else {
std::cerr << "ofs.good():" << ofs.good() << std::endl;
		}
#endif
//sleep (1);
	}

	return 0;
}
