/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_SSL_SOCKET_HPP
#define SL_INET_SSL_SOCKET_HPP

#include <unistd.h>
#include <openssl/ssl.h>
#include <boost/shared_ptr.hpp>

namespace sl {


/**
 * SSL ѻΥåݲΰ٤Υ饹.
 *
 * Boost.Asio Τ褦ʥԡ¤򤷤ƤʤΤ
 * SSLΥƥ(_ctx/_ssl) boost::shared_ptr 
 * 󥹥󥹤λȥȤ¸.
 *
 * ʤǥȥ饯Ǥ close ¹Ԥ櫓ˤϤʤΤ
 */
class ssl_socket {

    class context {
    public :
        context()
        {
            _ctx = ::SSL_CTX_new(::SSLv23_server_method());
            _ssl = ::SSL_new(_ctx);
        }

        ~context()
        {
            ::SSL_free(_ssl);
            ::SSL_CTX_free(_ctx);
        }
        ::SSL_CTX* _ctx;
        ::SSL* _ssl;
    };

public :
    ssl_socket() : _socket(-1)
    {
        _context = boost::shared_ptr<context>(new context());
    }

    ~ssl_socket()
    {
    }

    ::SSL* socket() { return _context->_ssl; }
    int descriptor() { return _socket; }
    bool alive() { return _socket != -1; }
    void close()
    {
        ::SSL_shutdown(_context->_ssl);
        ::close(_socket);
        _socket = -1;
    }

    int _socket;

private :
    boost::shared_ptr<context> _context;
};


} // namespace sl

#endif // SL_INET_SSL_SOCKET_HPP
