/*-
 * Copyright (c) 2009 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_HTTP_RANGE_HEADER_P_HPP
#define SL_HTTP_RANGE_HEADER_P_HPP

#include <string>
#include <vector>

#include <sl/inet/http_util/basic_parse_rules_in_BNF.hpp>

namespace sl { namespace http {


/**
 * HTTP إå Range Υѡ饹.
 *
 * <pre>
 *
 * Range            = "Range" ":" ranges-specifier
 * ranges-specifier = byte-ranges-specifier
 * byte-ranges-specifier = bytes-unit "=" byte-range-set
 * byte-range-set   = 1#( byte-range-spec | suffix-byte-range-spec )
 * byte-range-spec  = first-byte-pos "-" [ last-byte-pos ]
 * first-byte-pos   = 1*DIGIT
 * last-byte-pos    = 1*DIGIT
 * suffix-byte-range-spec = "-" suffix-length
 * suffix-length    = 1*DIGIT
 *
 *
 *   RFC 2616  3.12 Range Units
 * range-unit       = bytes-unit | other-range-unit
 * bytes-unit       = "bytes"
 * other-range-unit = token
 *
 * </pre>
 */
class range_header_p {
public :

    /**
     * ϴؿ.
     *  s ΥإåԤϤη̤ media ݻޤ.
     * ݻ ',' Ƕڤ줿ƥǥǤ.
     *
     * @param s ϤԤإå.
     * @param media Ϸ̤ݻ뤿 std::vector<std::string> .
     * @return Ϸ̤β.
     */
    static bool parse(const std::string& s, std::vector<std::string>& media)
    {
        std::string tmp = s;
        return parse((std::string&)tmp, media);
    }

    /*
     * إåβϷ(media)  ":" ʹߤʸ(̾',')
     * ڤäΤ¸Ƥ뤬Range إåǤ ":" ³
     * "bytes=" ʬפʤ
     * ̤Ȥݻͤ "bytes=" ʬˤ
     */
    static bool parse(std::string& s, std::vector<std::string>& media)
    {
        std::string::iterator i = s.begin();
        std::string::iterator e = s.end();

        /* ranges-specifier = byte-ranges-specifier */
        /* byte-ranges-specifier = bytes-unit "=" byte-range-set */
        /* bytes-unit       = "bytes" */

        sw(i);

        if (eq(i, "bytes") && sw(i) && eq(i, '=')) {
            for (;;) {
                sw(i);

                std::string::iterator p = i;
                if (!byte_range_spec(i, e) && !suffix_byte_range_spec(i, e))
                    return false;

                media.push_back(std::string(p, i));

                sw(i);
                if (i == e) break;
                if (*i++ != ',') return false;
            }
            if (media.empty()) return false;
        } else
            return false;
        return true;
    }

private :

    static
    bool byte_range_spec(std::string::iterator& i, std::string::iterator& e)
    {
        /*
         * byte-range-spec  = first-byte-pos "-" [ last-byte-pos ]
         * first-byte-pos   = 1*DIGIT
         * last-byte-pos    = 1*DIGIT
         */
        std::string::iterator p = i;
        if (DIGIT(i)) {
            while (DIGIT(i)) /* nothing */;

            if (eq(i, '-')) {
                if (DIGIT(i))
                    while (DIGIT(i)) /* nothing */;
                return true;
            }
        }
        i = p;
        return false;
    }

    static
    bool suffix_byte_range_spec(std::string::iterator& i,
                                std::string::iterator& e)
    {
        /* suffix-byte-range-spec = "-" suffix-length */

        if (eq(i, '-')) {
            if (DIGIT(i)) {
                while (DIGIT(i)) /* nothing */;
                return true;
            }
        }
        std::string::iterator p = i;
        i = p;
        return false;
    }
};

} } // namespace sl::http

#endif // SL_HTTP_RANGE_HEADER_P_HPP
