/*-
 * Copyright (c) 2009 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_HTTP_ACCEPT_ENCODING_HEADER_P_HPP
#define SL_HTTP_ACCEPT_ENCODING_HEADER_P_HPP

#include <string>
#include <vector>

#include <sl/inet/http_util/basic_parse_rules_in_BNF.hpp>

namespace sl { namespace http {


/**
 * HTTP إå Accept-Encoding Υѡ饹.
 *
 * <pre>
 *
 * Accept-Encoding  = "Accept-Encoding" ":"
 *                  1#( codings [ ";" "q" "=" qvalue] )
 * codings          = ( content-coding | "*" )
 * content-coding   = token
 *
 * Accept-Encoding: compress, gzip
 * Accept-Encoding: *
 * Accept-Encoding: compress;q=0.5, gzip;q=1.0
 * Accept-Encoding: gzip;q=1.0, identity; q=0.5, *;q=0
 * 
 * </pre> 
 */
class accept_encoding_header_p {
public :

    /**
     * ϴؿ.
     *  s ΥإåԤϤη̤ media ݻޤ.
     * ݻ ',' Ƕڤ줿ƥǥǤ.
     *
     * @param s ϤԤإå.
     * @param media Ϸ̤ݻ뤿 std::vector<std::string> .
     * @return Ϸ̤β.
     */
    static bool parse(const std::string& s, std::vector<std::string>& media)
    {
        std::string tmp = s;
        return parse((std::string&)tmp, media);
    }

    static bool parse(std::string& s, std::vector<std::string>& media)
    {
        std::string::iterator i = s.begin();
        std::string::iterator e = s.end();

        for (;;) {
            sw(i);
            std::string::iterator p = i;

            if (codings(i, e)) {
                if (*i == ';') {
                    if (eq(i, ';') && sw(i) && eq(i, 'q') && sw(i) &&
                        eq(i, '=') && sw(i) && qvalue(i, e)) /* nothing */;
                    else
                       return false;
                }
            } else if (eq(i, '*'))
                /* nothing */;
            else
                return false;

            media.push_back(std::string(p, i));

            sw(i);
            if (i == e) break;
            if (*i++ != ',') return false;
        }

        return true;
    }

private :

    static
    bool codings(std::string::iterator& i, std::string::iterator& e)
    {
        return token(i, e);
    }
};

} } // namespace sl::http

#endif // SL_HTTP_ACCEPT_ENCODING_HEADER_P_HPP
