/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_HTTP_RESPONSE_WRITER_HPP
#define SL_INET_HTTP_RESPONSE_WRITER_HPP

#include <iostream>
#include <stdexcept>
#include <string>

#include <sl/inet/http_request.hpp>
#include <sl/inet/http_response.hpp>
#include <sl/inet/http_util.hpp>

namespace sl { namespace http {


class http_response_writer {
public :
    http_response_writer();
    http_response_writer(std::ostream& stream, http_request& request);

    void reset(std::ostream& stream, http_request& request);
    void flush_all(http_response& res);
    void flush_headers(http_response& res);
    void flush_content(http_response& res);
    void commit(http_response& res);
    void keep_alive(bool flag);

private :
    std::ostream* _stream;
    http_request* _request;

    bool _chunked;
    bool _commited;
    bool _http_ver10;
    bool _keep_alive_possible;
    std::string _http_ver10_body;
};

} } // namespace sl::http


#endif // SL_INET_HTTP_RESPONSE_WRITER_HPP
