/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_HTTP_RESPONSE_HPP
#define SL_INET_HTTP_RESPONSE_HPP

#include <string>
#include <boost/lexical_cast.hpp>

#include <sl/inet/message.hpp>

namespace sl { namespace http {

class http_response : public sl::http::message {
public :
    http_response() { reset(); }
    virtual ~http_response() { }

    void reset()
    {
        sl::http::message::reset();

        _version = "HTTP/1.1";
        _status_code = 0;
        _reason_phrase = "OK";
    }

    //////////////////////////////////////////////////////////////////////
    // Inherited pure virtual funtions.
    //

    virtual int type() const
    {
        return 1;
    }

    virtual std::string start_line() const
    {
        return status_line();
    }

    //////////////////////////////////////////////////////////////////////
    // HTTP-Response Implement funtions.
    //
    std::string status_line() const
    {
        return  _version + " " +
                boost::lexical_cast<std::string>(_status_code) + " " +
                _reason_phrase;
    }

    void status_code(int code) { _status_code = code; }
    int status_code() const { return _status_code; }
    void version(const std::string& s) { _version = s; }
    std::string version() const { return _version; }
    void reason_phrase(const std::string& s) { _reason_phrase = s; }
    std::string reason_phrase() const { return _reason_phrase; }

    bool keep_alive() const
    {
        return boost::equals(msg_header("Connection"), "keep-alive", boost::is_iequal());
    }

private :
    int _status_code;
    std::string _version;
    std::string _reason_phrase;
};

} } // namespace sl::http


#endif // SL_INET_HTTP_RESPONSE_HPP
