/*-
 * Copyright (c) 2005 masashi osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: date.h,v 1.2 2008/03/01 03:27:47 cvsuser Exp $
 */

#ifndef SL_INET_DATE_H
#define SL_INET_DATE_H

#include <ctime>
#include <string>
#include <vector>


#if defined(__CYGWIN__)
namespace {
extern "C" {
    char* strptime(const char *, const char *, struct tm *);
}
}
#endif

namespace sl { namespace http {

/**
 * ʸǤդȿɽ֤ѴԤ饹Ǥ.
 * ʲΥեޥåȤ᤹뤳ȤǽǤ.
 * 
 * 31/Jun/1999                        Ūʥե
 * 31/Jun/1999:21:31:05               Ūʥե
 * 08-Jun-1999 01:15:01 GMT           줿RFC850 
 * 08-Jun-1999                        줿 RFC850 HTTP 
 * 08-Jun-98 01:15:01 GMT             RFC850 
 * 08-Jun-98                          ŤRFC850 HTTP 
 * 09 Jun 1999 22:23:32 GMT           HTTP 
 * 09 Jun 1999                        Ƥ줿HTTP 
 * 12-01-98  31:52PM                  Windows 'dir' 
 * 1999-01-31 01:15:01 -0100          ISO 8601 
 * 1999-01-31 01:15:01                ӡzoneˤϥץ
 * 1999-01-31                         դΤ
 * 1999-01-31T01:15:01                ѥ졼ȤTȤ
 * 19990131                           դΤ
 * 19990131T011501Z                   ISO 8601 ѥ
 * Jun  3  1999                       Unix 'ls -l'
 * Jun  3 21:31                       Unix 'ls -l'
 * Thu Jun  3 01:02:03 1999           ANSI C asctime() 
 * Thu Jun  3 21:31:10 GMT 1999       ctime(3) 
 * Tuesday, 08-Jun-1999 01:15:01 GMT  줿 RFC850 HTTP 
 * Tuesday, 08-Jun-98 01:15:01 GMT    old RFC850 HTTP 
 * Wed, 09 Jun 1999 21:22:23 GMT      HTTP 
 */
class date {
    typedef std::vector<std::string> slist_t;

public :

    /**
     *  s Ϥtime_t Ѵ֤ͤޤ.
     * ޤǤ硢Ѵ˼Ԥ
     * ͤ 0 Ȥʤޤ.
     *
     * @param    s    Http-Date դʸ
     * @return    Ѵ time_t .
     */
    static time_t string_to_time(const std::string &s)
    {
        std::string str(s);
        std::string::size_type pos;

        while ((pos = str.find("  ")) != std::string::npos ||
               (pos = str.find("\t")) != std::string::npos)
            str.erase(pos, 1);

        slist_t::iterator i = instance()._format_list.begin();
        for (; i != instance()._format_list.end(); i++) {
            struct tm t;
            memset(&t, 0x00, sizeof(struct tm));

                if (strptime(str.c_str(), i->c_str(), &t) != NULL) {
                if (t.tm_year == 0) {
                    time_t dummy;
                    ::time(&dummy);
                    struct tm now = *gmtime(&dummy);
                    t.tm_year = now.tm_year;
                }
#ifdef CYGWIN
                return mktime(&t) + 9 * 60 * 60;
#else
                return timegm(&t);
#endif
            }
        }
        return 0;
    }

    /**
     *  t ϤʸѴ֤ͤޤ.
     * ޤ t Ͻʤ϶ʸ֤ޤ.
     *
     * @param    clock    Ѵоݤ time_t .
     * @return     clock Ѵ std::string ʸ.
     */
    static std::string time_to_string(time_t clock)
    {
        struct tm t = *gmtime(&clock);
        char time_string[64];

        int ret = strftime(time_string,32,"%a, %d %b %Y %H:%M:%S GMT",&t);
        return ret != 0 ? time_string : std::string();
    }

    /**
     * ߻ʸȤ֤ޤ.
     *
     * @return    ߻ʸ.
     */
    static std::string current_time()
    {
        return time_to_string(::time(NULL));
    }

private :
    /** Constructor. */
    date()
    {
        _format_list.push_back("%A, %d-%b-%Y %H:%M:%S GMT");
        _format_list.push_back("%A, %d-%b-%y %H:%M:%S GMT");
        _format_list.push_back("%Y%m%dT%H%M%S");
        _format_list.push_back("%Y-%m-%d %H:%M:%S");
        _format_list.push_back("%Y-%m-%dT%H:%M:%S");
        _format_list.push_back("%a %b %e %H:%M:%S %Y");
        _format_list.push_back("%a %b %e %H:%M:%S GMT %Y");
        _format_list.push_back("%a, %d %b %Y %H:%M:%S");
        _format_list.push_back("%b %e %H:%M");
        _format_list.push_back("%b %e %Y");
        _format_list.push_back("%d %b %Y %H:%M:%S GMT");
        _format_list.push_back("%d-%b-%Y %H:%M:%S GMT");
        _format_list.push_back("%d-%b-%y %H:%M:%S GMT");
        _format_list.push_back("%d/%b/%Y %H:%M:%S GMT");
        _format_list.push_back("%d/%b/%Y:%H:%M:%S GMT");
        _format_list.push_back("%m-%d-%y %H:%MPM");
    }

    static date& instance()
    {
        static date instance;
        return instance;
    }

    slist_t _format_list;
};

} } // namespace sl::http

#endif // SL_INET_DATE_H
