/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_ASIO_ACCEPTOR_HPP
#define SL_INET_ASIO_ACCEPTOR_HPP

#include <iostream>
#include <string>
#include <boost/asio.hpp>

namespace sl {


class asio_acceptor {
public :
    typedef std::string init_args_type;

    asio_acceptor() : _io_service(), _acceptor(_io_service) { }
    virtual ~asio_acceptor() { destroy(); }

    void init(const init_args_type& port)
    {
        std::string address = "0.0.0.0";
        boost::asio::ip::tcp::resolver resolver(_io_service);
        boost::asio::ip::tcp::resolver::query query(address, port);
        boost::asio::ip::tcp::endpoint endpoint = *resolver.resolve(query);

        _acceptor.open(endpoint.protocol());
        _acceptor.set_option(boost::asio::ip::tcp::acceptor::reuse_address(true));
        _acceptor.set_option(boost::asio::ip::tcp::no_delay(true));
        _acceptor.bind(endpoint);
        _acceptor.listen();
    }

    void destroy() throw()
    {
        _acceptor.close();
    }

    void accept(boost::asio::ip::tcp::iostream& stream) // throw()
    {    
        _acceptor.accept(*stream.rdbuf());
    }

private :
    boost::asio::io_service            _io_service;
    boost::asio::ip::tcp::acceptor    _acceptor;
};


} // namespace sl

#endif // SL_INET_ASIO_ACCEPTOR_HPP
