/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_AJP13_RESPONSE_WRITER_HPP
#define SL_INET_AJP13_RESPONSE_WRITER_HPP

#include <iostream>
#include <string>

#include <sl/inet/ajp13_request.hpp>
#include <sl/inet/ajp13_response.hpp>

namespace sl { namespace ajp13 {


class ajp13_response_writer {
public :
    ajp13_response_writer() : _stream(0), _request(0) { }

    ajp13_response_writer(std::ostream& stream, ajp13_request& request)
    { reset(stream, request); }

    void reset(std::ostream& stream, ajp13_request& request)
    {
        _stream   = &stream;
        _request  = &request;
#if 0
        _commited = false;
        _chunked  = false;
        _http_ver10 = false;
        _http_ver10_body.clear();
#endif
    }

    void flush_all(ajp13_response& res)
    {
    }

    void flush_headers(ajp13_response& res)
    {
    }

    void flush_content(ajp13_response& res)
    {
    }

    void commit(ajp13_response& res)
    {
    }

private :
    std::ostream* _stream;
    ajp13_request* _request;
};


} } // namespace sl::ajp13


#endif // SL_INET_AJP13_RESPONSE_WRITER_HPP
