/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_AJP13_RESPONSE_HPP
#define SL_INET_AJP13_RESPONSE_HPP

#include <sl/inet/message.hpp>

namespace sl { namespace ajp13 {

class ajp13_response : public sl::http::message {
public :
    ajp13_response() : _keep_alive(false) { }
    virtual ~ajp13_response() { }

    void keep_alive(bool i) { _keep_alive = i; }
    bool keep_alive() const { return _keep_alive; }

    void reset()
    {
        _keep_alive = false;
        _version = "HTTP/1.1";
        _status_code = 200;
        _reason_phrase = "OK";
    }

    //////////////////////////////////////////////////////////////////////
    // Inherited pure virtual funtions.
    //

    virtual int type() const
    {
        return 1;
    }

    virtual std::string start_line() const
    {
        return status_line();
    }

    //////////////////////////////////////////////////////////////////////
    // HTTP-Response Implement funtions.
    //
    std::string status_line() const
    {
        return  _version + " " +
                boost::lexical_cast<std::string>(_status_code) + " " +
                _reason_phrase;
    }

    void status_code(int code) { _status_code = code; }
    void version(const std::string& s) { _version = s; }
    void reason_phrase(const std::string& s) { _reason_phrase = s; }

private :
    bool _keep_alive;

    int _status_code;
    std::string _version;
    std::string _reason_phrase;
};

} } // namespace sl::ajp13


#endif // SL_INET_AJP13_RESPONSE_HPP
