/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_INET_AJP13_REQUEST_PARSER_HPP
#define SL_INET_AJP13_REQUEST_PARSER_HPP

#include <iostream>
#include <stdexcept>
#include <string>

#include <sl/inet/ajp13_request.hpp>

namespace sl { namespace ajp13 {

class ajp13_request_reader {
public :
    static bool is_empty_line(const std::string& line)
    {
        return (line.empty() || line[0] == '\r' || line[0] == '\n');
    }

    static void parse(std::istream& stream, ajp13_request& req)
    {
        sl::ajp13::forward_request_packet& packet = req.request_packet();

        try {
            sl::ajp13::read_packet(stream, packet);
            

packet.dump(std::cerr);
//            if (_headers.content_length() > 0)
//                read_packet(fd, _body_chunk);
        } catch(std::exception& e) {
            std::cerr << e.what() << std::endl;
            throw;
        }
        req.state(ajp13_request::normality);
    }
};

} } // namespace sl::ajp13


#endif // SL_INET_AJP13_REQUEST_PARSER_HPP
