/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: function.h,v 1.1 2008/02/02 17:51:45 cvsuser Exp $
 */

#ifndef SL_NET_AJP13_FUNCTION_H
#define SL_NET_AJP13_FUNCTION_H

#include <iostream>
#include <algorithm>

#include "types.h"
#include "packet.h"
#include "ajp13_error.h"

namespace sl {
    namespace ajp13 {

	/**
	 * pByte֥Ȥޤ.
	 * @param	p	ХƬΥݥ.
	 * @return	Byte.
	 */
	inline Byte get_byte(const char *p)
	{
		return p ? *p : 0;
	}

	/**
	 * pBoolean֥Ȥޤ.
	 * @param	p	ХƬΥݥ.
	 * @return	Boolean.
	 */
	inline Boolean get_boolean(const char *p)
	{
		return (p && *p) ? 0x01 : 0x00;
	}

	/**
	 * pInteger֥Ȥޤ.
	 * @param	p	ХƬΥݥ.
	 * @return	Integer.
	 */
	inline Integer get_integer(const char *p)
	{
		return p ? (*p << 8) | (0x00ff & *(p + 1)) : 0;
	}

	/**
	 * pString֥Ȥޤ.
	 * @param	p	ХƬΥݥ.
	 * @return	String.
	 */
	inline String get_string(const char *p)
	{
		return String(&*p);
	}

	/**
	 * Byte b  p ˥ԡޤ.
	 * @param	p	ХƬΥݥ.
	 * @param	b	Byte.
	 */
	inline int to_char(char *p, Byte b)
	{
		*p = b;
		return sizeof(Byte);
	} 

	/**
	 * Boolean b  p ˥ԡޤ.
	 * @param	p	ХƬΥݥ.
	 * @param	b	Boolean.
	 */
	inline int to_char(char *p, Boolean b)
	{
		*p = b ? 0x01 : 0x00;
		return sizeof(Boolean);
	}

	/**
	 * Integer i  p ˥ԡޤ.
	 * @param	p	ХƬΥݥ.
	 * @param	i	Integer.
	 */
	inline int to_char(char *p, Integer i)
	{
		*p = i >> 8;
		*(++p) = 0xff00 | i;
		return sizeof(Integer);
	}

	/**
	 * String s  p ˥ԡޤ.
	 * @param	p	ХƬΥݥ.
	 * @param	s	String.
	 */
	inline int to_char(char *p, String &s)
	{
		to_char(p, s.length());
		std::copy(s.data(), s.data() + s.length(), p + sizeof(Integer));
		return *p;
	}

	/**
	 * fd ɤ߹ǡˤäpacket饹ΥѥåȤޤ.
	 * @param	fd	եǥץ.
	 * @param	p	packet饹Ѿ.
	 * @throw	ajp13_error	ǡɤ߹ߡѥåȺ
	 *				Ԥꤲޤ.
	 */
	void read_packet(int fd, packet &p)
		throw(ajp13_error);

	/**
	 * inɤ߹ǡˤäpacket饹ΥѥåȤޤ.
	 * @param	in	ϥȥ꡼.
	 * @param	p	packet饹Ѿ.
	 * @throw	ajp13_error	ǡɤ߹ߡѥåȺ
	 *				Ԥꤲޤ.
	 */
	void read_packet(std::istream &in, packet &p)
		throw(ajp13_error);


	/**
	 * ѥåȥإåղäƥѥåȤ fd ؽϤޤ.
	 * ѥåȤƬꤵޥåȥѥåȤĹ
	 * ĥХp ΥХϢ뤷 fd ؽϤޤ.
	 * @param	fd	եǥץ.
	 * @param	p	packet饹Ѿ.
	 * @throw	ajp13_error	ǡ񤭹ߤ˼Ԥꤲޤ.
	 */
	void write_packet(int fd, const packet &p)
		throw(ajp13_error);

	/**
	 * ѥåȥإåղäƥѥåȤ os ؽϤޤ.
	 * ѥåȤƬꤵޥåȥѥåȤĹ
	 * ĥХp ΥХϢ뤷 os ؽϤޤ.
	 * @param	os	ϥȥ꡼.
	 * @param	p	packet饹Ѿ.
	 * @throw	ajp13_error	ǡ񤭹ߤ˼Ԥꤲޤ.
	 */
	void write_packet(std::ostream &os, const packet &p)
		throw(ajp13_error);

    } // namespace ajp13
} // namespace sl

#include "function.cpp"

#endif // SL_NET_AJP13_FUNCTION_H
