/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_CPP_PARSER_HPP
#define SL_CPP_PARSER_HPP

#include <string>

#include "cxxgrammar.hpp"

namespace sl {

	/**
	 * @class cxxparser.
	 *
	 * class/namespace ޤե(ϥإåե)Ϥ
	 * XMLեȤƽϤޤ.
	 *
	 */
	class cxxparser {
	public :

		/** Constuctor. */
		cxxparser()
		{ }

		bool start(const std::string& file)
		{
			std::string s;
			cpp_grammar g;
	
			boost::spirit::parse_info<> info =
						boost::spirit::parse(file.c_str(), g, space_p);
			if (!info.full) {
				std::cerr << "parsing failed" << std::endl;
				std::cerr << "line at:" << info.stop << std::endl;
				return false;
			}
			return true;
		}

	};

} // namespace sl

#endif // SL_CPP_PARSER_HPP
