/*-
 * Copyright (c) 2005 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: grammar.h,v 1.2 2008/01/05 07:02:07 cvsuser Exp $
 */

#ifndef SL_CPP_PARSER_GRAMMAR_H
#define SL_CPP_PARSER_GRAMMAR_H

#include <iostream>
#include <string>
#include <boost/algorithm/string/find.hpp>
#include <boost/bind.hpp>

#ifdef DEBUG
#define BOOST_SPIRIT_DEBUG
#endif
#define BOOST_SPIRIT_THREADSAFE
#include <boost/spirit.hpp>
#include <boost/spirit/phoenix.hpp>

#if 0
#define BOOST_SPIRIT_NO_REGEX_LIB
#include <boost/spirit/utility/regex.hpp>
#include <boost/thread/mutex.hpp>
#endif
using namespace std;
using namespace boost;
using namespace boost::spirit;


namespace sl {

    /**
     * @class cpp_grammar.
     *
     * ʸϤΥ롼饹.
     * namespace class дؿȰ¤βϥ롼Ǥ.
     *
     */
    class cpp_grammar : public grammar<cpp_grammar> {
    public :

        struct string_closure : closure<string_closure, std::string>
        {
            member1 val;
        };

        typedef string_closure                            __closure_type;

        template <typename ScannerT>
        struct definition
        {
            rule<ScannerT> _top;
            rule<ScannerT, typename __closure_type::context_t>
#include "p_list_def.hpp"
            ;

            definition(const cpp_grammar& self)
            {
                using phoenix::arg1;
                using phoenix::arg2;
                using boost::bind;

#define CHAR     str_p("char")
#define WCHAR_T  str_p("wchar_t")
#define BOOL     str_p("bool")
#define SHORT    str_p("short")
#define INT      str_p("int")
#define LONG     str_p("long")
#define SIGNED   str_p("signed")
#define UNSIGNED str_p("unsigned")
#define FLOAT    str_p("float")
#define DOUBLE   str_p("double")
#define VOID     str_p("void")

#define AUTO     str_p("auto")
#define REGISTER str_p("register")
#define STATIC   str_p("static")
#define EXTERN   str_p("extern")
#define MUTABLE  str_p("mutable")
#define INLINE   str_p("inline")
#define VIRTUAL  str_p("virtual")
#define EXPLICIT str_p("explicit")

#define FRIEND   str_p("friend")
#define TYPEDEF  str_p("typedef")
#define USING    str_p("using")
#define ASM      str_p("asm")
#define NAMESPACE str_p("namespace")
#define CLASS    str_p("class")
#define TEMPLATE str_p("template")
#define TYPENAME str_p("typename")
#define STRUCT   str_p("struct")
#define UNION    str_p("union")
#define ENUM     str_p("enum")
#define PUBLIC   str_p("public")
#define PROTECTED str_p("protected")
#define PRIVATE  str_p("private")
#define OPERATOR str_p("operator")
#define CONST    str_p("const")
#define VOLATILE str_p("volatile")
#define EXPORT   str_p("export")
#define SIZEOF   str_p("sizeof")
#define TYPEID   str_p("typeid")

#define CONST_CAST str_p("const_cast")
#define STATIC_CAST str_p("static_cast")
#define DYNAMIC_CAST str_p("dynamic_cast")
#define REINTERPRET_CAST str_p("reinterpret_cast")

#define COMMA    str_p(",")
#define DOT      str_p(".")
#define AST      str_p("*")
#define AMP      str_p("&")

#define NAMESPACE_SCOPE      str_p("::")
#define NAMESPACE_OPT      *(NAMESPACE_SCOPE)
#define VAR_ARG            str_p("...")
#define VAR_ARG_OPT        *(VAR_ARG)

#define IF     str_p("if")
#define ELSE   str_p("else")
#define SWITCH str_p("switch")
#define FOR    str_p("for")
#define WHILE  str_p("while")
#define CASE   str_p("case")
#define DEFAULT str_p("default")
#define DO     str_p("do")
#define BREAK  str_p("break")
#define CONTINUE str_p("continue")
#define RETURN str_p("return")
#define GOTO   str_p("goto")
#define THROW  str_p("throw")
#define TRY    str_p("try")
#define CATCH  str_p("catch")
#define PP     str_p("#")


//////////////////////////////////////////////////////////////////////////////
// --- ANCI C++ grammar

_top    = _translation_unit
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.1  Keywords                                               [gram.key]

#if 0
 _typedef_name
        = _identifier
        ;
 _namespace_name
        = _original_namespace_name
        | _namespace_alias
        ;
 _original_namespace_name
        = _identifier
        ;
 _namespace_alias
        = _identifier
        ;
 _class_name
        = _identifier
        | _template_id
        ;
 _enum_name
        = _identifier
        ;
 _template_name
        = _identifier
        ;
#endif

//////////////////////////////////////////////////////////////////////////////
//  1.2  Lexical conventions                                    [gram.lex]
_hex_quad
        = _hexadecimal_digit >>_hexadecimal_digit >> _hexadecimal_digit >> _hexadecimal_digit
        ;
_universal_character_name
        = "\\u" >> _hex_quad
        | "\\U" >> _hex_quad >> _hex_quad
        ;
_preprocessing_token
        = _header_name
        | _identifier
        | _pp_number
        | _character_literal
        | _string_literal
        | _preprocessing_op_or_punc
//        each non_white_space character that cannot be one of the above
        ;
_token
        = _identifier
//        | _keyword
        | _literal
        | _operator
//        | _punctuator
        ;
_header_name
        = "<" >> _h_char_sequence >> ">"
        | "\"" >> _q_char_sequence >> "\""
        ;
_h_char_sequence
        = _h_char
        | _h_char_sequence >> _h_char
        ;
_h_char
        = chset<>("a-zA-Z0-9")
        ;
        //any member of the source character set except
        //        new_line and >
_q_char_sequence
        = _q_char
        | _q_char_sequence >> _q_char
        ;
_q_char
        = chset<>("a-zA-Z0-9")
        ;
_pp_number
        = _digit
        | DOT >> _digit
        | _pp_number >> _digit
        | _pp_number >> _nondigit
        | _pp_number >> "e" >> _sign
        | _pp_number >> "E" >> _sign
        | _pp_number >> DOT
        ;
_identifier
        = +(_nondigit) >> *(_nondigit | _digit)
        ;
_nondigit
        = _universal_character_name
        | "_" | "a" | "b" | "c" | "d" | "e" | "f" | "g" | "h" | "i" | "j" | "k" | "l" | "m"
        |       "n" | "o" | "p" | "q" | "r" | "s" | "t" | "u" | "v" | "w" | "x" | "y" | "z"
        |       "A" | "B" | "C" | "D" | "E" | "F" | "G" | "H" | "I" | "J" | "K" | "L" | "M"
        |       "N" | "O" | "P" | "Q" | "R" | "S" | "T" | "U" | "V" | "W" | "X" | "Y" | "Z"
        ;
_digit
        = str_p("0") | "1" | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"
        ;
_preprocessing_op_or_punc
        = str_p("{")   | "}"  | "["  | "]"  | "#"  | "##"  | "("  | ")"
        | "<:"  | ":>" | "<%" | "%>" | "%:" | "%:%:"| ";"  | ":"   | "..."
        | "new" | "delete"    | "?"  | "::" | "."   | ".*"
        | "+"   | "-"  | "*"  | "/"  | "%"  | "^"   | "&"  | "|"   | "~"
        | "!"   | "="  | "<"  | ">"  | "+=" | "-="  | "*=" | "/="  | "%="
        | "^="  | "&=" | "|=" | "<<" | ">>" | ">>=" | "<<="| "=="  | "!="
        | "<="  | ">=" | "&&" | "||" | "++" | "--"  | ","  | "->*" | "->"
        | "and" | "and_eq" | "bitand" | "bitor" | "compl"  | "not" | "not_eq" | "or" |   "or_eq"
        | "xor" |  "xor_eq"
        ;
_literal
        = _integer_literal
        | _character_literal
        | _floating_literal
        | _string_literal
        | _boolean_literal
        ;
_integer_literal
        = _decimal_literal >> *(_integer_suffix)
        | _octal_literal >> *(_integer_suffix)
        | _hexadecimal_literal >> *(_integer_suffix)
        ;
_decimal_literal
        = _nonzero_digit
        | _decimal_literal >> _digit
        ;
_octal_literal
        = "0"
        | _octal_literal >> _octal_digit
        ;
_hexadecimal_literal
        = "0x" >> _hexadecimal_digit
        | "0X" >> _hexadecimal_digit
        | _hexadecimal_literal >> _hexadecimal_digit
        ;
_nonzero_digit
        = str_p("1") | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"
        ;
_octal_digit
        = str_p("0") | "1" | "2" | "3" | "4" | "5" | "6" | "7"
        ;
_hexadecimal_digit
        = str_p("1") | "2" | "3" | "4" | "5" | "6" | "7" | "8" | "9"
        | "a" | "b" | "c" | "d" | "e" | "f"
        | "A" | "B" | "C" | "D" | "E" | "F"
        ;
_integer_suffix
        = _unsigned_suffix >> *(_long_suffix)
        | _long_suffix >> *(_unsigned_suffix)
        ;
_unsigned_suffix
        = str_p("u") | "U"
        ;
_long_suffix
        = str_p("l") | "L"
        ;
_character_literal
        = str_p("'") >> _c_char_sequence >> "'"
        | str_p("L") >> "'" >> _c_char_sequence >> "'"
        ;
_c_char_sequence
        = _c_char
        | _c_char_sequence >> _c_char
        ;
_c_char
        //any member of the source character set except
        //        the single_quote ', backslash \, or new_line character
        = _escape_sequence
        | _universal_character_name
        ;
_escape_sequence
        = _simple_escape_sequence
        | _octal_escape_sequence
        | _hexadecimal_escape_sequence
        ;
_simple_escape_sequence
        = str_p("\\'") | "\\\"" | "\\?" | "\\\\"
        | "\\a" | "\\b" | "\\f" | "\\n" | "\\r" | "\\t" | "\\v"
        ;
_octal_escape_sequence
        = "\\" >> _octal_digit
        | "\\" >> _octal_digit >> _octal_digit
        | "\\" >> _octal_digit >> _octal_digit >> _octal_digit
        ;
_hexadecimal_escape_sequence
        = "\\x" >> _hexadecimal_digit
        | _hexadecimal_escape_sequence >> _hexadecimal_digit
        ;
_floating_literal
        = _fractional_constant >> *(_exponent_part) >> *(_floating_suffix)
        | _digit_sequence >> _exponent_part >> *(_floating_suffix)
        ;
_fractional_constant
        = *(_digit_sequence) >> "." >> _digit_sequence
        | _digit_sequence >> "."
        ;
_exponent_part
        = "e" >> *(_sign) >> _digit_sequence
        | "E" >> *(_sign) >> _digit_sequence
        ;
_sign
        = str_p("+") | "-"
        ;
_digit_sequence
        = _digit
        | _digit_sequence >> _digit
        ;
_floating_suffix
        = str_p("f") | "l" | "F" | "L"
        ;
_string_literal
        = "\"" >> *(_s_char_sequence) >> "\""
        | str_p("L") >> "\"" >> *(_s_char_sequence) >> "\""
        ;
_s_char_sequence
        = _s_char
        | _s_char_sequence >> _s_char
        ;
_s_char
        //any member of the source character set except
        //        the double_quote ", backslash \, or new_line character
        = _escape_sequence
        | _universal_character_name
        ;
_boolean_literal
        = str_p("false") | "true"
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.3  Basic concepts                                       [gram.basic]
_translation_unit
        = *(_declaration_seq)
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.4  Expressions                                           [gram.expr]
_primary_expression
        = _literal
        | "this"
        | NAMESPACE_SCOPE >> _identifier
        | NAMESPACE_SCOPE >> _operator_function_id
        | NAMESPACE_SCOPE >> _qualified_id
        | str_p("(") >> _expression >> ")"
        | _id_expression
        ;
_id_expression
        = _unqualified_id
        | _qualified_id
        ;
_unqualified_id
        = _identifier
        | _operator_function_id
        | _conversion_function_id
        | str_p("~") >> _class_name
        | _template_id
        ;
_qualified_id
        = _nested_name_specifier >> *(TEMPLATE) >> _unqualified_id
        ;
_nested_name_specifier
        = _class_or_namespace_name >> NAMESPACE_SCOPE >> *(_nested_name_specifier)
        ;
_class_or_namespace_name
        = _class_name
        | _namespace_name
        ;
_postfix_expression
        = _primary_expression
        | _postfix_expression >> "[" >> _expression >> "]"
        | _postfix_expression >> "(" >> *(_expression_list) >> ")"
        | _simple_type_specifier >> "(" >> *(_expression_list) >> ")"
        | _postfix_expression >> "." >> *(TEMPLATE) >> NAMESPACE_OPT >> _id_expression
        | _postfix_expression >> "->" >> *(TEMPLATE) >> NAMESPACE_OPT >> _id_expression
        | _postfix_expression >> "." >> _pseudo_destructor_name
        | _postfix_expression >> "->" >> _pseudo_destructor_name
        | _postfix_expression >> "++"
        | _postfix_expression >> "--"
        | DYNAMIC_CAST >> "<" >> _type_id >> ">" >> "(" >> _expression >> ")"
        | STATIC_CAST >> "<" >> _type_id >> ">" >> "(" >> _expression >> ")"
        | REINTERPRET_CAST >> "<" >> _type_id >> ">" >> "(" >> _expression >> ")"
        | CONST_CAST >> "<" >> _type_id >> ">" >> "(" >> _expression >> ")"
        | TYPEID >> "(" >> _expression >> ")"
        | TYPEID >> "(" >> _type_id >> ")"
        ;
_expression_list
        = _assignment_expression
        | _expression_list >> "," >> _assignment_expression
        ;
_pseudo_destructor_name
        = NAMESPACE_OPT >> *(_nested_name_specifier) >> _type_name >> NAMESPACE_SCOPE >> "~" >> _type_name
        | NAMESPACE_OPT >> *(_nested_name_specifier) >> "~" >> _type_name
        ;
_unary_expression
        = _postfix_expression
        | "++" >> _cast_expression
        | "--" >> _cast_expression
        | _unary_operator >> _cast_expression
        | SIZEOF >> _unary_expression
        | SIZEOF >> "(" >> _type_id >> ")"
        | _new_expression
        | _delete_expression
        ;
_unary_operator
        = str_p("*") | "&" | "+" | "-" | "!" | "~"
        ;
_new_expression
        = NAMESPACE_OPT >> "new" >> *(_new_placement) >> _new_type_id >> *(_new_initializer)
        | NAMESPACE_OPT >> "new" >> *(_new_placement) >> "(" >> _type_id >> ")" >> *(_new_initializer)
        ;
_new_placement
        = "(" >> _expression_list >> ")"
        ;
_new_type_id
        = _type_specifier_seq >> *(_new_declarator)
        ;
_new_declarator
        = _ptr_operator >> *(_new_declarator)
        | _direct_new_declarator
        ;
_direct_new_declarator
        = str_p("[") >> _expression >> "]"
        | _direct_new_declarator >> "[" >> _constant_expression >> "]"
        ;
_new_initializer
        = str_p("(") >> *(_expression_list) >> ")"
        ;
_delete_expression
        = NAMESPACE_OPT >> "delete" >> _cast_expression
        | NAMESPACE_OPT >> "delete" >> "[" >> "]" >> _cast_expression
        ;
_cast_expression
        = _unary_expression
        | str_p("(") >> _type_id >> ")" >> _cast_expression
        ;
_pm_expression
        = _cast_expression
        | _pm_expression >> ".*" >> _cast_expression
        | _pm_expression >> "->*" >> _cast_expression
        ;
_multiplicative_expression
        = _pm_expression
        | _multiplicative_expression >> "*" >> _pm_expression
        | _multiplicative_expression >> "/" >> _pm_expression
        | _multiplicative_expression >> "%" >> _pm_expression
        ;
_additive_expression
        = _multiplicative_expression
        | _additive_expression >> "+" >> _multiplicative_expression
        | _additive_expression >> "-" >> _multiplicative_expression
        ;
_shift_expression
        = _additive_expression
        | _shift_expression >> "<<" >> _additive_expression
        | _shift_expression >> ">>" >> _additive_expression
        ;
_relational_expression
        = _shift_expression
        | _relational_expression >> "<" >> _shift_expression
        | _relational_expression >> ">" >> _shift_expression
        | _relational_expression >> "<=" >> _shift_expression
        | _relational_expression >> ">=" >> _shift_expression
        ;
_equality_expression
        = _relational_expression
        | _equality_expression >> "==" >> _relational_expression
        | _equality_expression >> "!=" >> _relational_expression
        ;
_and_expression
        = _equality_expression
        | _and_expression >> "&" >> _equality_expression
        ;
_exclusive_or_expression
        = _and_expression
        | _exclusive_or_expression >> "^" >> _and_expression
        ;
_inclusive_or_expression
        = _exclusive_or_expression
        | _inclusive_or_expression >> "|" >> _exclusive_or_expression
        ;
_logical_and_expression
        = _inclusive_or_expression
        | _logical_and_expression >> "&&" >> _inclusive_or_expression
        ;
_logical_or_expression
        = _logical_and_expression
        | _logical_or_expression >> "||" >> _logical_and_expression
        ;
_conditional_expression
        = _logical_or_expression
        | _logical_or_expression >> "?" >> _expression >> ":" >> _assignment_expression
        ;
_assignment_expression
        = _conditional_expression
        | _logical_or_expression >> _assignment_operator >> _assignment_expression
        | _throw_expression
        ;
_assignment_operator
        = str_p("=") | "*=" | "/=" | "%=" | "+=" | "-=" | ">>=" | "<<=" | "&=" | "^=" |"="
        ;
_expression
        = _assignment_expression
        | _expression >> "," >> _assignment_expression
        ;
_constant_expression
        = _conditional_expression
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.5  Statements                                       [gram.stmt.stmt]
_statement
        = _labeled_statement
        | _expression_statement
        | _compound_statement
        | _selection_statement
        | _iteration_statement
        | _jump_statement
        | _declaration_statement
        | _try_block
        ;
_labeled_statement
        = _identifier >> ":" >> _statement
        | CASE >> _constant_expression >> ":" >> _statement
        | DEFAULT >> ":" >> _statement
        ;
_expression_statement
        = *(_expression) >> ";"
        ;
_compound_statement
        = "{" >> *(_statement_seq) >> "}"
        ;
_statement_seq
        = _statement
        | _statement_seq >> _statement
        ;
_selection_statement
        = IF >> "(" >> _condition >> ")" >> _statement
        | IF >> "(" >> _condition >> ")" >> _statement >> ELSE >> _statement
        | SWITCH >> "(" >> _condition >> ")" >> _statement
        ;
_condition
        = _expression
        | _type_specifier_seq >> _declarator >> "=" >> _assignment_expression
        ;
_iteration_statement
        = WHILE >> "(" >> _condition >> ")" >> _statement
        | DO >> _statement >> WHILE >> "(" >> _expression >> ")" >> ";"
        | FOR >> "(" >> _for_init_statement >> *(_condition) >> ";" >> *(_expression) >> ")" >> _statement
        ;
_for_init_statement
        = _expression_statement
        | _simple_declaration
        ;
_jump_statement
        = BREAK >> ";"
        | CONTINUE >> ";"
        | RETURN >> *(_expression) >> ";"
        | GOTO >> _identifier >> ";"
        ;
_declaration_statement
        = _block_declaration
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.6  Declarations                                       [gram.dcl.dcl]

_declaration_seq
        = *(_declaration)
        ;
_declaration
        = _block_declaration
        | _function_definition
        | _template_declaration
        | _explicit_instantiation
        | _explicit_specialization
        | _linkage_specification
        | _namespace_definition
        ;
_block_declaration
        = _simple_declaration
        | _asm_definition
        | _namespace_alias_definition
        | _using_declaration
        | _using_directive
        ;
_simple_declaration
        = *(_decl_specifier_seq) >> *(_init_declarator_list)
        ;
_decl_specifier
        = _storage_class_specifier
        | _type_specifier
        | _function_specifier
        | FRIEND
        | TYPEDEF
        ;
_decl_specifier_seq
        = +(_decl_specifier)
        ;
_storage_class_specifier
        = AUTO
        | REGISTER
        | STATIC
        | EXTERN
        | MUTABLE
        ;
_function_specifier
        = INLINE
        | VIRTUAL
        | EXPLICIT
        ;
_typedef_name
        = _identifier
        ;
_type_specifier
        = _simple_type_specifier
        | _class_specifier
        | _enum_specifier
        | _elaborated_type_specifier
        | _cv_qualifier
        ;
_simple_type_specifier
        = NAMESPACE_OPT >> *(_nested_name_specifier) >> _type_name
        | CHAR
        | WCHAR_T
        | BOOL
        | SHORT
        | INT
        | LONG
        | SIGNED 
        | UNSIGNED
        | FLOAT
        | DOUBLE
        | VOID
        ;
_type_name
        = _class_name
        | _enum_name
        | _typedef_name
        ;
_elaborated_type_specifier
        = _class_key >> NAMESPACE_OPT >> *(_nested_name_specifier) >> _identifier
        | ENUM >> NAMESPACE_OPT >> *(_nested_name_specifier) >> _identifier
        | TYPENAME >> NAMESPACE_OPT >> _nested_name_specifier >> _identifier
        | TYPENAME >> NAMESPACE_OPT >> _nested_name_specifier >> _identifier >> "<" >> _template_argument_list >> ">"
        ;
_enum_name
        = _identifier
        ;
_enum_specifier
        = ENUM >> *(_identifier) >> "{" >> *(_enumerator_list) >> "}"
        ;

_enumerator_list
        = _enumerator_definition
        | _enumerator_list >> "," >> _enumerator_definition
        ;
_enumerator_definition
        = _enumerator
        | _enumerator >> "=" >> _constant_expression
        ;
_enumerator
        = _identifier
        ;
_namespace_name
        = _original_namespace_name
        | _namespace_alias
        ;
_original_namespace_name
        = _identifier
        ;

_namespace_definition
        = _named_namespace_definition
        | _unnamed_namespace_definition
        ;

_named_namespace_definition
        = _original_namespace_definition
        | _extension_namespace_definition
        ;

_original_namespace_definition
        = NAMESPACE >> _identifier >> "{" >> _namespace_body >> "}"
        ;

_extension_namespace_definition
        = NAMESPACE >> _original_namespace_name >> "{" >> _namespace_body >> "}"
        ;

_unnamed_namespace_definition
        = NAMESPACE >> "{" >> _namespace_body >> "}"
        ;

_namespace_body
        = *(_declaration_seq)
        ;
_namespace_alias
        = _identifier
        ;

_namespace_alias_definition
        = NAMESPACE >> _identifier >> "=" >> _qualified_namespace_specifier
        ;

_qualified_namespace_specifier
        = NAMESPACE_OPT >> *(_nested_name_specifier) >> _namespace_name
        ;
_using_declaration
        = USING >> *(TYPENAME) >> NAMESPACE_OPT >> _nested_name_specifier >> _unqualified_id
        | USING >> NAMESPACE_SCOPE >> _unqualified_id
        ;
_using_directive
        = USING >> NAMESPACE >> NAMESPACE_OPT >> *(_nested_name_specifier) >> _namespace_name
        ;
_asm_definition
        = ASM >> "(" >> _string_literal >> ")"
        ;
_linkage_specification
        = EXTERN >> _string_literal >> "{" >> *(_declaration_seq) >> "}"
        | EXTERN >> _string_literal >> _declaration
        ;

//////////////////////////////////////////////////////////////////////////////
//  1.7  Declarators                                       [gram.dcl.decl]

_init_declarator_list
        = _init_declarator
        | _init_declarator_list >> "," >> _init_declarator
        ;
_init_declarator
        = _declarator >> *(_initializer)
        ;
_declarator
        = _direct_declarator
        | _ptr_operator >> _declarator
        ;
_direct_declarator
        = _declarator_id
        | _declarator_id >> "(" >> _parameter_declaration_clause >> ")" >> *(_cv_qualifier_seq) >> *(_exception_specification)
        | _declarator_id >> "[" >> *(_constant_expression) >> "]"
        | "(" >> _declarator >> ")"
        ;
_ptr_operator
        = AST >> *(_cv_qualifier_seq)
        | AMP
        | NAMESPACE_OPT >> _nested_name_specifier >> AST >> *(_cv_qualifier_seq)
		;
_cv_qualifier_seq
        = _cv_qualifier >> *(_cv_qualifier_seq)
        ;
_cv_qualifier
        = CONST
        | VOLATILE
        ;
_declarator_id
        = NAMESPACE_OPT >> _id_expression
        | NAMESPACE_OPT >> *(_nested_name_specifier) >> _type_name
        ;
_type_id
        = _type_specifier_seq >> *(_abstract_declarator)
        ;
_type_specifier_seq
        = _type_specifier >> *(_type_specifier_seq)
        ;
_abstract_declarator
        = _ptr_operator >> *(_abstract_declarator)
        | _direct_abstract_declarator
        ;
_direct_abstract_declarator
        = *(_direct_abstract_declarator) >> "(" >> _parameter_declaration_clause >> ")" >> *(_cv_qualifier_seq) >> *(_exception_specification)
        | *(_direct_abstract_declarator) >> "[" >> *(_constant_expression) >> "]"
        | "(" >> _abstract_declarator >> ")"
        ;
_parameter_declaration_clause
        = *(_parameter_declaration_list)
        | _parameter_declaration_list >> COMMA >> VAR_ARG
        ;
_parameter_declaration_list
        = _parameter_declaration
        | _parameter_declaration >> COMMA >> _parameter_declaration
        ;
_parameter_declaration
        = _decl_specifier_seq >> _declarator
        | _decl_specifier_seq >> _declarator >> "=" >> _assignment_expression
        | _decl_specifier_seq >> *(_abstract_declarator)
        | _decl_specifier_seq >> *(_abstract_declarator) >> "=" >> _assignment_expression
        ;
_function_definition
        = *(_decl_specifier_seq) >> _declarator >> *(_ctor_initializer) >> _function_body
        | *(_decl_specifier_seq) >> _declarator >> _function_try_block
        ;
_function_body
        = _compound_statement
        ;
_initializer
        = _initializer_clause
        | "(" >> _expression_list >> ")"
        ;
_initializer_clause
        = _assignment_expression
        | "{" >> _initializer_list >> *(COMMA) >> "}"
        | str_p("{") >> "}"
        ;
_initializer_list
        = _initializer_clause
        | _initializer_list >> "," >> _initializer_clause
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.8  Classes                                              [gram.class]

_class_name
        = _identifier
        | _template_id
        ;
_class_specifier
        = _class_head >> "{" >> *(_member_specification) >> "}"
        ;
_class_head
        = _class_key >> *(_identifier) >> *(_base_clause)
        | _class_key >> _nested_name_specifier >> _identifier >> *(_base_clause)
        ;
_class_key
        = CLASS
        | STRUCT
        | UNION
        ;
_member_specification
        = _member_declaration >> *(_member_specification)
        | _access_specifier >> ":" >> *(_member_specification)
        ;
_member_declaration
        = *(_decl_specifier_seq) >> *(_member_declarator_list) >> ";"
        | _function_definition >> *(";")
        | _qualified_id >> ";"
        | _using_declaration
        | _template_declaration
        ;
_member_declarator_list
        = _member_declarator
        | _member_declarator_list >> "," >> _member_declarator
        ;
_member_declarator
        = _declarator >> *(_pure_specifier)
        | _declarator >> *(_constant_initializer)
        | *(_identifier) >> ":" >> _constant_expression
        ;
_pure_specifier
        = str_p("=") >> "0"
        ;
_constant_initializer
        = _constant_expression
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.9  Derived classes                              [gram.class.derived]

_base_clause
        = _base_specifier_list
        ;
_base_specifier_list
        = _base_specifier
        | _base_specifier_list >> "," >> _base_specifier
        ;
_base_specifier
        = NAMESPACE_OPT >> *(_nested_name_specifier) >> _class_name
        | VIRTUAL >> *(_access_specifier) >> NAMESPACE_OPT >> *(_nested_name_specifier) >> _class_name
        | _access_specifier >> *(VIRTUAL) >> NAMESPACE_OPT >> *(_nested_name_specifier) >> _class_name
        ;
_access_specifier
        = PRIVATE
        | PROTECTED
        | PUBLIC
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.10  Special member functions                          [gram.special]

_conversion_function_id
        = OPERATOR >> _conversion_type_id
        ;
_conversion_type_id
        = _type_specifier_seq >> *(_conversion_declarator)
        ;
_conversion_declarator
        = _ptr_operator >> *(_conversion_declarator)
        ;
_ctor_initializer
        = ":" >> _mem_initializer_list
        ;
_mem_initializer_list
        = _mem_initializer
        | _mem_initializer >> "," >> _mem_initializer_list
        ;
_mem_initializer
        = _mem_initializer_id >> "(" >> *(_expression_list) >> ")"
        ;
_mem_initializer_id
        = NAMESPACE_OPT >> *(_nested_name_specifier) >> _class_name
        | _identifier
        ;

//////////////////////////////////////////////////////////////////////////////
//  1.11  Overloading                                          [gram.over]

_operator_function_id
        = OPERATOR >> _operator
        ;
_operator
        = str_p("new") | "delete" | "new[]" | "delete[]" 
        | "+"  | "-"  | "*"  | "/"  | "%"  | "^"  | "&"  | "|"  | "~"
        | "!"  | "="  | "<"  | ">"  | "+=" | "-=" | "*=" | "/=" | "%="
        | "^=" | "&=" | "|=" | "<<" | ">>" | ">>="| "<<="| "==" | "!="
        | "<=" | ">=" | "&&" | "||" | "++" | "--" | ","  | "->*"| "->"
        | "()" | "[]"
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.12  Templates                                            [gram.temp]

_template_declaration
        = *(EXPORT) >> TEMPLATE >> "<" >> _template_parameter_list >> ">" >> _declaration
        ;
_template_parameter_list
        = _template_parameter
        | _template_parameter_list >> "," >> _template_parameter
        ;
_template_parameter
        = _type_parameter
        | _parameter_declaration
        ;
_type_parameter
        = CLASS >> *(_identifier)
        | CLASS >> *(_identifier) >> "=" >> _type_id
        | TYPENAME >> *(_identifier)
        | TYPENAME >> *(_identifier) >> "=" >> _type_id
        | TEMPLATE >> "<" >> _template_parameter_list >> ">" >> CLASS >> *(_identifier)
        | TEMPLATE >> "<" >> _template_parameter_list >> ">" >> CLASS >> *(_identifier) >> "=" >> _template_name
        ;
_template_id
        = _template_name >> "<" >> _template_argument_list >> ">"
        ;
_template_name
        = _identifier
        ;
_template_argument_list
        = _template_argument
        | _template_argument >> COMMA >> _template_argument
        ;
_template_argument
        = _assignment_expression
        | _type_id
        | _template_name
        ;
_explicit_instantiation
        = _template_declaration
        ;
_explicit_specialization
        = TEMPLATE >> "< >" >> _declaration
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.13  Exception handling                                 [gram.except]
_try_block
        = TRY >> _compound_statement >> _handler_seq
        ;
_function_try_block
        = TRY >> *(_ctor_initializer) >> _function_body >> _handler_seq
        ;
_handler_seq
        = _handler >> *(_handler_seq)
		;
_handler
        = CATCH >> "(" >> _exception_declaration >> ")" >> _compound_statement
        ;
_exception_declaration
        = _type_specifier_seq >> _declarator
        | _type_specifier_seq >>_abstract_declarator
        | _type_specifier_seq
        | "..."
        ;
_throw_expression
        = THROW >> *(_assignment_expression)
        ;
_exception_specification
        = THROW >> "(" >> *(_type_id_list) >> ")"
        ;
_type_id_list
        = _type_id
        | _type_id_list >> "," >> _type_id
        ;


//////////////////////////////////////////////////////////////////////////////
//  1.14  Preprocessing directives                              [gram.cpp]
_preprocessing_file
        = *(_group)
        ;
_group
        = _group_part
        | _group >> _group_part
        ;
_group_part
        = *(_pp_tokens) >> _new_line
        | _if_section
        | _control_line
        ;
_if_section
        = _if_group >> *(_elif_groups) >> *(_else_group) >> _endif_line
        ;
_if_group
        = PP >> "if"     >> _constant_expression >> _new_line >> *(_group)
        | PP >> "ifdef"  >> _identifier >> _new_line >> *(_group)
        | PP >> "ifndef" >> _identifier >> _new_line >> *(_group)
        ;
_elif_groups
        = _elif_group
        | _elif_groups >> _elif_group
        ;
_elif_group
        = PP >> "elif"   >> _constant_expression >> _new_line >> *(_group)
        ;
_else_group
        = PP >> "else"   >> _new_line >> *(_group)
        ;
_endif_line
        = PP >> "endif"  >> _new_line
        ;
_control_line
        = PP >> "include" >> _pp_tokens >> _new_line
        | PP >> "define" >> _identifier >> _replacement_list >> _new_line
//        | PP >> "define" >> _identifier >> _lparen >> *(_identifier_list) >> ")" >> _replacement_list >> _new_line
        | PP >> "undef"   >> _identifier >> _new_line
        | PP >> "line"    >> _pp_tokens >> _new_line
        | PP >> "error"   >> *(_pp_tokens) >> _new_line
        | PP >> "pragma"  >> *(_pp_tokens) >> _new_line
        | PP >>         _new_line
        ;
_lparen
        = chset<>("a-zA-Z0-9")
        ;
_replacement_list
        = *(_pp_tokens)
        ;
_pp_tokens
        = _preprocessing_token
        | _pp_tokens >> _preprocessing_token
        ;
_new_line
        = str_p("\n") | str_p("\r\n")
        ;



#include "p_list_debug.hpp"

            }
            const rule<ScannerT>& start() const { return _top; }
        };
    };


} // namespace sl

#endif // SL_CPP_PARSER_GRAMMAR_H
