/*-
 * Copyright (c) 2008 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef SL_CLASS_LOADER_DITAIL_DL_IMPL_HPP
#define SL_CLASS_LOADER_DITAIL_DL_IMPL_HPP

#include <dlfcn.h>
#include <map>
#include <string>
#include <stdexcept>
#include <sl/mangle/demangle.hpp>
#include <sl/mangle/mangle.hpp>

namespace sl { namespace detail {

/**
 * dlfcn Ϥδؿåפ뤿Υ饹.
 *
 * ޤ̣Ϥʤɥƥ¸δؿ¹ԤϰåפƤ.
 *
 */
class dl_impl {
public :
    static void* open(const std::string& path)
    {
        if (path.empty())
            throw std::invalid_argument("dl_impl::open failed. path is empty.");

        void* p = ::dlopen(path.c_str(), RTLD_GLOBAL | RTLD_NOW);
        if (!p)
            throw std::runtime_error(
                std::string("dl_impl::open failed. can not open: ") + path);

        return p;
    }

    static void close(void* handle)
    {
        if (!handle)
            throw std::invalid_argument("dl_impl::open failed. handle is NULL.");

        ::dlclose(handle);
    }

    /**
     * ⥸塼ΥܥΥɥ쥹.
     *
     * C++Ǥܥϥޥ󥰥뤵뤿
     * 1˻ꤹ륷ܥ̾ϥޥ󥰥뤵Ƥɬפ.
     * ʤΤ1ޥ󥰥뤷Ƥʤ 2 false 
     * ꤹ뤳Ȥˤޥ󥰥¹Ը˥ܥ븡Ԥʤ褦ˤƤ.
     *
     * @param name ܥ̾.
     * @param mangled ܥ̾Υޥ󥰥¹Ԥ̵ͭ.
     * @return ܥΥɥ쥹.
     */
    static void* symbol(void* handle, const std::string& name, bool mangled = true)
    {
        if (!handle)
            throw std::invalid_argument("dl_impl::symbol failed. handle is Null.");
        if (name.empty())
            throw std::invalid_argument("dl_impl::symbol failed. name is empty.");
        void* p = 0;
        if (mangled)
            p = ::dlsym(handle, name.c_str());
        else
            p = ::dlsym(handle, sl::mangle(name).c_str());

        if (!p) {
            throw std::runtime_error(
                std::string("dl_impl::symbol failed. ") + ::dlerror());
        }
        return p;
    }
};

} } // namespace sl::detail

#endif // SL_CLASS_LOADER_DITAIL_DL_IMPL_HPP
