#include <iostream>
#include <string>
#include <sl/object.hpp>

void do_something(const sl::object& o)
{
	std::cerr << sl::object_cast<std::string>(o) << std::endl;
}


int main()
{
	std::string s1("abc");
	sl::object o1(s1);
	std::cerr << sl::object_cast<std::string>(o1) << std::endl;

	sl::object_cast<std::string>(o1) += "def";
	std::cerr << sl::object_cast<std::string>(o1) << std::endl;

	sl::object o2("ABC");
	std::cerr << sl::object_cast<const char*>(o2) << std::endl;
	std::cerr << sl::object_cast<std::string>(o2) << std::endl;

	do_something("fff"); // const char*
	do_something(s1);    // std::string

	return 0;
}
