/*-
 * Copyright (c) 2009 Masashi Osakabe
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <unistd.h>
#include <iostream>
#include <string>
#include <sl/mangle/mangle.hpp>
#include <sl/mangle/demangle.hpp>

void usage()
{
    std::cout << "Usage: mg [option] arg" << std::endl;
    std::cout << "  -m     : arg Фƥޥ󥰥Ԥʤ(ǥե)" << std::endl;
    std::cout << "  -d     : arg Фƥǥޥ󥰥Ԥʤ" << std::endl;
    exit(1);
}

int main(int argc, char** argv)
{
    int mode = 0; // 0 mangle, 1 demangle
    int ch;
    while ((ch = ::getopt(argc, argv, "hdm")) != -1) {
        switch (ch) {
        case 'd':
            mode = 1;
            break;
        case 'm':
            mode = 0;
            break;
        case 'h':
        case '?':
        default:
            usage();
        }
    }
    argc -= optind;
    argv += optind;

    if (argc != 1) usage();

    std::string input(*argv);
    try {
        if (mode)
            std::cout << sl::demangle(input) << std::endl;
        else
            std::cout << sl::mangle(input) << std::endl;
    } catch (std::exception& e) {
        std::cerr << "fatal error!!! " << e.what() << std::endl;
        return 1;
    }

    return 0;
}
