#include <fcntl.h>
#include <cerrno>
#include <string>

#define SL_INET_SOCKSTREAM_BUFLEN 4000
#include <sl/inet/sockstream.hpp>
#include <sl/inet/basic_socket.hpp>
#include <sl/inet/http_request_reader.hpp>

const std::string file = "./sockstream_test.txt";
const std::string test =
"POST / HTTP/1.0\r\n"
"Content-Type: text/plain\r\n"
"Content-Length: 10\r\n"
"\r\n"
"1234567890";

int write()
{
	int fd = ::open(file.c_str(), O_WRONLY | O_CREAT | O_TRUNC);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	{
	sl::basic_socket socket(fd);
	sl::osstream os(socket);
	os << test; // destructor with sync()
	}
	close(fd);
	return 0;
}

int read1()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::isstream is;
	is.reset(socket);
	is.rlength(test.length()); // Value of lie.

	std::string result;
	while (!is.eof()) {
		std::getline(is, result);
		std::cerr << result << std::endl;
	}
	close(fd);

	return 0;
}

void read2_sub(std::istream& is)
{
	sl::http::http_request req;
	sl::http::http_request_reader::parse(is, req);

	std::cerr << req;

	std::string result;
	while (!is.eof()) {
		std::getline(is, result);
		std::cerr << result << std::endl;
	}
}

int read2()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::iosstream is;
	is.reset(socket);
	is.rlength(test.length()); // Value of lie.

	read2_sub(is);
	close(fd);

	return 0;
}

int main()
{
	if (write()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	if (read1()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	if (read2()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	return 0;
}
