#include <fcntl.h>
#include <cerrno>
#include <string>

#define SL_INET_SOCKSTREAM_BUFLEN 4000
#include <sl/inet/sockstream.hpp>
#include <sl/inet/basic_socket.hpp>

const std::string file = "./sockstream_test.txt";
const std::string test = "12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890";

int write()
{
	int fd = ::open(file.c_str(), O_WRONLY | O_CREAT | O_TRUNC);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	{
	sl::basic_socket socket(fd);
	sl::osstream os(socket);
	os << test; // destructor with sync()
	}
	close(fd);
	return 0;
}

int read1()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::isstream is;
	is.reset(socket);
	is.rlength(test.length() - 50); // Value of lie.

	std::string result;
	is >> result;
	close(fd);

	if (result.length() != test.length() - 50) {
		std::cerr << "unmatch :[" << result << "]" << std::endl;
		return 1;
	}
	return 0;
}

int read2()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::isstream is;
	is.reset(socket);
	is.rlength(test.length() + 50); // Value of lie.

	std::string result;
	is >> result;
	close(fd);

	if (result.length() != test.length()) {
		std::cerr << "unmatch :[" << result << "]" << std::endl;
		return 1;
	}
	return 0;
}

int read3()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::isstream is;
	is.reset(socket);
	//is.rlength(test.length());

	std::string result;
	is >> result;
	close(fd);

	if (result.length() != test.length()) {
		std::cerr << "unmatch :[" << result << "]" << std::endl;
		return 1;
	}
	return 0;
}

int read4()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::isstream is;
	is.reset(socket);

	std::string result;
	while (!is.eof()) {
		result.append(1, static_cast<char>(is.get()));
	}
	close(fd);

	if (result.length() != test.length()) {
		std::cerr << "unmatch " << std::endl;
		std::cerr << "[" << result.length() << "]" << std::endl;
		std::cerr << "[" << test.length() << "]" << std::endl;
		return 1;
	}
	return 0;
}

int main()
{
	if (write()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	if (read1()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	if (read2()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	if (read3()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	if (read4()) {
		std::cerr << "fail:" << __LINE__ << std::endl;
		return 1;
	}
	return 0;
}
