#include <fcntl.h>
#include <cerrno>
#include <string>

#include <sl/inet/sockstream.hpp>
#include <sl/inet/basic_socket.hpp>

const std::string file = "./sockstream_test.txt";
const std::string test = "1234567890";

int write()
{
	int fd = ::open(file.c_str(), O_WRONLY | O_CREAT | O_TRUNC);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	{
	sl::basic_socket socket(fd);
	sl::osstream os(socket);
	os << test; // destructor with sync()
	}
	close(fd);
	return 0;
}

int read()
{
	int fd = ::open(file.c_str(), O_RDONLY);
	if (fd == -1) {
		std::cerr << strerror(errno) << std::endl;
		return 1;
	}

	sl::basic_socket socket(fd);

	sl::isstream is;
	is.reset(socket);
	is.rlength(test.length());

	std::string result;
	is >> result;
	close(fd);

	if (result != test) {
		std::cerr << "unmatch :[" << result << "]" << std::endl;
		return 1;
	}
	return 0;
}

int main()
{
	if (write())
		return 1;
	if (read())
		return 1;
	return 0;
}
