#include <iostream>
#include <sstream>

#define SL_INET_DEBUG
//#define USE_SSL

#include <sl/inet/connector.hpp>
#include <sl/inet/acceptor.hpp>
#include <sl/inet/http_connection.hpp>
#include <sl/inet/ssl_acceptor.hpp>
#include <sl/inet/ssl_connection.hpp>
#include <sl/inet/ajp13_connection.hpp>
#include <sl/inet/derived_type_pool.hpp>
#include <sl/inet/types.h>

std::string content;


template <class ConnectionType>
void request_handler(ConnectionType& c)
{
#ifdef DEBUG
	std::cerr << __FUNCTION__ << std::endl;
	std::cerr << c.request() << std::endl;
	std::cerr << c.request().abs_path() << std::endl;
#endif
#ifdef DEBUG 
	std::string body;
	std::istream &in = c.request().stream();
	std::cerr << in.good() << std::endl;
	in >> body;
	std::cerr << "body:" << body << std::endl;
#endif
#ifdef DEBUG
    while (!in.eof()) {
		std::cerr << in.get() << std::endl;
    }
#endif
	c.response().status_code(200);
	c.response().reason_phrase(sl::http::status_code::to_string(200));
	c.response().msg_body(content);
	c.response().msg_header("Content-Length", content.length());

	typename ConnectionType::response_writer_type writer = c.writer();

	writer.flush_headers(c.response());
	writer.flush_content(c.response());
	writer.commit(c.response());
}



int main(int argc, char** argv)
{
	sigset_t	set;
	sigfillset(&set);

	sigprocmask(SIG_BLOCK, &set, NULL);

#if 1
	for (int i = 0; i < 10; i++)
		content += "a";
#else
	content += "<html>\n";
	content += "<body>\n";
	content += "CGI TEST TEST\n";
	content += "<hr />\n";
	content += "<form action=\"/cgi-bin/test/input.cgi\"  method=\"GET\">\n";
	content += "<input type=\"text\" name=\"input\" size=\"20\" />\n";
	content += "<input type=\"submit\" name=\"submit\" value=\"\" />\n";
	content += "</form>\n";
	content += "<form action=\"/cgi-bin/test/input.cgi\"  method=\"POST\">\n";
	content += "<input type=\"text\" name=\"input\" size=\"20\" />\n";
	content += "<input type=\"submit\" name=\"submit\" value=\"\" />\n";
	content += "</form>\n";
	content += "<form action=\"/cgi-bin/test/input.cgi\" method=\"POST\" enctype=\"multipart/form-data\">\n";
	content += "<input type=\"file\" name=\"input\" size=\"20\" />\n";
	content += "<input type=\"submit\" name=\"submit\" value=\"\" />\n";
	content += "</form>\n";
	content += "</body>\n";
	content += "</html>\n";
#endif

	typedef sl::connector<sl::acceptor, sl::http_connection>	http_connector;
	typedef sl::connector<sl::acceptor, sl::ajp13_connection>	ajp_connector;
	typedef sl::connector<sl::ssl_acceptor, sl::ssl_connection>	ssl_connector;

	typedef sl::connector<sl::acceptor,
						sl::http_connection,
						sl::derived_type_pool<sl::http_connection> >
		sp_pool_connector;

	http_connector c(&request_handler<http_connector::connection_type>);
#if 1
	ssl_connector  s(&request_handler<ssl_connector::connection_type>);
	ajp_connector  a(&request_handler<ajp_connector::connection_type>);
#endif
	sp_pool_connector	sp(&request_handler<sp_pool_connector::connection_type>);
	size_t	max_t = 50;// ν¹ԥåɿ.
	size_t	max_s = 10;	// ν¹Ԥåɿ.
	time_t	ctime = 15;	// ³ǡޤǤΥॢȻ.
	time_t	ptime = 30;	// ֤ΥॢȻ.
	time_t	ktime = 10;	// keep-alive timeout;
	size_t	ksize = 100;	// keep-alive connection size;

	c.init(http_connector::connector_args(ksize),
           http_connector::acceptor_args("8080"),
		   http_connector::connection_args(ctime, ptime, ktime),
		   http_connector::pool_args(max_t, max_s, 0));
#if 0
	s.init(ssl_connector::acceptor_args(
				"8443", "misc/public.key", "misc/private.key"),
		   ssl_connector::connection_args(ctime, ptime, ksize, ktime),
		   ssl_connector::pool_args(max_t, max_s, 0));

	a.init(ajp_connector::acceptor_args("8009"));
#endif
	sp.init(sp_pool_connector::connector_args(ksize),
            sp_pool_connector::acceptor_args("8081"));

	std::cerr << "HTTP:8080" << std::endl;
	std::cerr << "SSL :8443" << std::endl;
	std::cerr << "AJP :8009" << std::endl;
	std::cerr << "SP  :8081" << std::endl;

	boost::thread t1(boost::bind(&http_connector::accept, boost::ref(c)));
#if 0
	boost::thread t2(boost::bind(&http_connector::accept, boost::ref(c)));
	boost::thread t3(boost::bind(&http_connector::accept, boost::ref(c)));
	boost::thread t4(boost::bind(&http_connector::accept, boost::ref(c)));
#endif
#if 0
	boost::thread t2(boost::bind(&ssl_connector::accept, boost::ref(s)));
	boost::thread t3(boost::bind(&ajp_connector::accept, boost::ref(a)));
#endif
	boost::thread t4(boost::bind(&sp_pool_connector::accept, boost::ref(sp)));

	for (;;) {
		int sig;
		sigwait(&set, &sig);
		switch (sig) {
		case SIGINT:
			goto END;
		}
	}
END:
	c.destroy();
#if 0
	s.destroy();
	a.destroy();
	sp.destroy();
#endif
	t1.join();
#if 0
	t2.join();
	t3.join();
	t4.join();
#endif

	return 0;
}
