#include <deque>
#include <iostream>
#include <sstream>
#include <boost/bind.hpp>
#include <boost/shared_ptr.hpp>

#include <sl/inet/connector.hpp>
#include <sl/inet/acceptor.hpp>
#include <sl/inet/http_connection.hpp>
#include <sl/inet/types.h>


#ifdef PROFILE
void signal_handle(int sig) { }
#endif

std::string content;

template <class ConnectionType>
void request_handler(ConnectionType& c)
{
//	std::cerr << __FUNCTION__ << std::endl;
//	std::cerr << c.request() << std::endl;

	c.response().status_code(200);
	c.response().reason_phrase(sl::http::status_code::to_string(200));
	c.response().msg_body(content);
	c.response().msg_header("Content-Length", content.length());

	typename ConnectionType::response_writer_type writer = c.writer();

	writer.flush_headers(c.response());
	writer.flush_content(c.response());
	writer.commit(c.response());
}

void signal_wait(sigset_t& set)
{
	for (;;) {
		int sig;
		sigwait(&set, &sig);
		if (sig == SIGINT)
			return;
	}
}

int main(int argc, char** argv)
{
	if (argc < 3) {
		std::cerr << "invalid argument." << std::endl;
		exit(1);
	}

	std::cout << "data size:" << atoi(argv[2]) << std::endl;
	for (int i = 0; i < atoi(argv[2]); i++)
		content += "a";

	typedef sl::connector<sl::acceptor, sl::http_connection>
		http_connector;
	http_connector c(&request_handler<http_connector::connection_type>);

	size_t	max_t = 150;// ν¹ԥåɿ.
	size_t	max_s = 10;	// ν¹Ԥåɿ.
	time_t	ctime = 15;	// ³ǡޤǤΥॢȻ.
	time_t	ptime = 30;	// ֤ΥॢȻ.
	size_t	ksize = 30;	// keep-alive connection size;
	time_t	ktime = 30;	// keep-alive timeout;

	c.init(http_connector::connector_args(ksize),
           http_connector::acceptor_args("8080"),
		   http_connector::connection_args(ctime, ptime, ktime),
		   http_connector::pool_args(max_t, max_s, 0));

	std::deque<boost::shared_ptr<boost::thread> >	tqueue;

	for (int i = 0; i < atoi(argv[1]); i++)
		tqueue.push_back(
			boost::shared_ptr<boost::thread>(
				new boost::thread(
					boost::bind(&http_connector::accept, boost::ref(c)))));

#ifdef PROFILE
	signal(SIGPIPE, SIG_IGN);
	signal(SIGINT, &signal_handle);
	::select(0, NULL, NULL, NULL, NULL);
#else
	sigset_t	set;
	sigemptyset(&set);
	sigfillset(&set);
	sigprocmask(SIG_BLOCK, &set, NULL);

	boost::thread wait(boost::bind(&signal_wait, set));
	wait.join();
#endif
	c.destroy();

	std::deque<boost::shared_ptr<boost::thread> >::iterator i = tqueue.begin();
	for (; i != tqueue.end(); i++)
		(*i)->join();
	tqueue.clear();

	return 0;
}
