#include "config.h"

#include <iostream>
#include <sstream>

#ifdef HAVE_BOOST_ASIO
#include <sl/inet/connector.hpp>
#include <sl/inet/asio_acceptor.hpp>
#include <sl/inet/asio_http_connection.hpp>

#include <sl/inet/types.h>

std::string content;

template <class ConnectionType>
void request_handler(ConnectionType& c)
{
//	std::cerr << __FUNCTION__ << std::endl;
//	std::cerr << c.request() << std::endl;

	c.response().status_code(200);
	c.response().reason_phrase(sl::http::status_code::to_string(200));
	c.response().msg_body(content);
	c.response().msg_header("Content-Length", content.length());

	typename ConnectionType::response_writer_type writer = c.writer();

	writer.flush_headers(c.response());
	writer.flush_content(c.response());
	writer.commit(c.response());
}
#endif

int main(int argc, char** argv)
{
#ifdef HAVE_BOOST_ASIO
	sigset_t	set;
	sigfillset(&set);

	sigprocmask(SIG_BLOCK, &set, NULL);

	for (int i = 0; i < 1000; i++)
		content += "a";

	typedef sl::connector<sl::asio_acceptor, sl::asio_http_connection>
		connector_type;

	connector_type c(&request_handler<connector_type::connection_type>);
	c.init(connector_type::connector_args(100),
           connector_type::acceptor_args("8080"));

	boost::thread t1(boost::bind(&connector_type::accept, boost::ref(c)));

	for (;;) {
		int sig;
		sigwait(&set, &sig);
		switch (sig) {
		case SIGINT:
			goto END;
		}
	}
END:
	c.destroy();
	t1.join();

#endif
	return 0;
}
