#*-
# Copyright (c) 2008 Masashi Osakabe
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
#
# AX_CXXABI
#
# HAVE_CXXABI_H Ͽ SL_CXXABI_DEMANGLE  Makefile ɲä.
#

AC_DEFUN([AX_CXXABI],
[
   #
   # Whether "C++ ABI abi::__cxa_demangle()" exists is checked. 
   #
    AC_CACHE_CHECK(whether the $CXX supports C++ ABI(abi::__cxa_demangle),
        ax_cxxabi,
        [AC_LANG_PUSH([C++])
         AC_COMPILE_IFELSE(
            AC_LANG_PROGRAM(
                [[@%:@include <cxxabi.h>]],
                [[
                    abi::__cxa_demangle(0, 0, 0, 0);
                ]]),
            ax_cxxabi=yes, ax_cxxabi=no)
         AC_LANG_POP([C++])
        ]
    )
    if test "x$ax_cxxabi" = xyes ; then
        AC_DEFINE(HAVE_CXXABI_H,,
            [define if the C++ ABI abi::__cxa_demangle() is available])
        DEFINE_SL_CXXABI_DEMANGLE="#define SL_CXXABI_DEMANGLE"
        AC_SUBST(DEFINE_SL_CXXABI_DEMANGLE)
    else
        DEFINE_SL_CXXABI_DEMANGLE=""
        AC_SUBST(DEFINE_SL_CXXABI_DEMANGLE)
    fi

])
