##### http://autoconf-archive.cryp.to/ax_boost.html
#
# OBSOLETE MACRO
#
#   Use AX_BOOST_BASE in combination with library-specific macros.
#
# SYNOPSIS
#
#   AX_BOOST([MINIMUM-VERSION], [ACTION-IF-FOUND], [ACTION-IF-NOT-FOUND])
#
# DESCRIPTION
#
#   Test for the Boost C++ libraries of a particular version (or newer)
#
#   If no path to the installed boost library is given the macro
#   searchs under /usr, /usr/local, and /opt, and evaluates the
#   $BOOST_ROOT environment variable. Further documentation is
#   available at <http://randspringer.de/boost/index.html>.
#
#   This macro calls:
#
#     AC_SUBST(BOOST_CPPFLAGS) / AC_SUBST(BOOST_LDFLAGS)
#     AC_SUBST(BOOST_FILESYSTEM_LIB)
#     AC_SUBST(BOOST_PROGRAM_OPTIONS_LIB)
#     AC_SUBST(BOOST_THREAD_LIB)
#     AC_SUBST(BOOST_IOSTREAMS_LIB)
#     AC_SUBST(BOOST_SERIALIZATION_LIB)
#     AC_SUBST(BOOST_WSERIALIZATION_LIB)
#     AC_SUBST(BOOST_SIGNALS_LIB)
#     AC_SUBST(BOOST_DATE_TIME_LIB)
#     AC_SUBST(BOOST_REGEX_LIB)
#     AC_SUBST(BOOST_UNIT_TEST_FRAMEWORK_LIB)
#     AC_SUBST(BOOST_SYSTEM_LIB)
#
#   And sets:
#
#     HAVE_BOOST
#     HAVE_BOOST_FILESYSTEM
#     HAVE_BOOST_PROGRAM_OPTIONS
#     HAVE_BOOST_THREAD
#     HAVE_BOOST_IOSTREAMS
#     HAVE_BOOST_SERIALIZATION
#     HAVE_BOOST_SIGNALS
#     HAVE_BOOST_DATE_TIME
#     HAVE_BOOST_REGEX
#     HAVE_BOOST_UNIT_TEST_FRAMEWORK
#     HAVE_BOOST_ASIO
#     HAVE_BOOST_SYSTEM
#
# LAST MODIFICATION
#
#   2007-07-26
#
# COPYLEFT
#
#   Copyright (c) 2007 Thomas Porschberg <thomas@randspringer.de>
#
#   Copying and distribution of this file, with or without
#   modification, are permitted in any medium without royalty provided
#   the copyright notice and this notice are preserved.

AC_DEFUN([AX_BOOST],
[
    AC_ARG_WITH([boost],
        AS_HELP_STRING([--with-boost=DIR],
            [use boost (default is yes) specify the root directory for boost library (optional)]),
        [
         if test "$withval" = "no"; then
             want_boost="no"
         elif test "$withval" = "yes"; then
             want_boost="yes"
             ac_boost_path=""
         else
             want_boost="yes"
             ac_boost_path="$withval"
         fi
        ],
        [want_boost="yes"])

    AC_CANONICAL_BUILD

    ax_boost_install_prefix="/usr /usr/local /usr/pkg /opt"

    if test "x$want_boost" = xyes ; then
        AC_REQUIRE([AC_PROG_CC])
        boost_lib_version_req=ifelse([$1], ,1.20.0,$1)

        boost_lib_version_req_shorten=`expr $boost_lib_version_req : '\([[0-9]]*\.[[0-9]]*\)'`
        boost_lib_version_req_major=`expr $boost_lib_version_req : '\([[0-9]]*\)'`
        boost_lib_version_req_minor=`expr $boost_lib_version_req : '[[0-9]]*\.\([[0-9]]*\)'`
        boost_lib_version_req_sub_minor=`expr $boost_lib_version_req : '[[0-9]]*\.[[0-9]]*\.\([[0-9]]*\)'`

        if test "x$boost_lib_version_req_sub_minor" = "x" ; then
            boost_lib_version_req_sub_minor="0"
        fi

        WANT_BOOST_VERSION=`expr $boost_lib_version_req_major \* 100000 \+  $boost_lib_version_req_minor \* 100 \+ $boost_lib_version_req_sub_minor`
        AC_MSG_CHECKING(for boostlib >= $boost_lib_version_req)
        succeeded=no

        # first we check the system location for boost libraries
        # this location ist chosen if boost libraries are installed with the
        # --layout=system option
        # or if you install boost with RPM

        if test "$ac_boost_path" != ""; then
            BOOST_LDFLAGS="-L$ac_boost_path/lib"
            BOOST_CPPFLAGS="-I$ac_boost_path/include"
        else
            for ac_boost_path_tmp in $ax_boost_install_prefix ; do
                if test -d "$ac_boost_path_tmp/include/boost" && test -r "$ac_boost_path_tmp/include/boost"; then
                    BOOST_LDFLAGS="-L$ac_boost_path_tmp/lib"
                    BOOST_CPPFLAGS="-I$ac_boost_path_tmp/include"
                    break;
                fi
            done
        fi

        CPPFLAGS_SAVED="$CPPFLAGS"
        CPPFLAGS="$CPPFLAGS $BOOST_CPPFLAGS"
        export CPPFLAGS
    
        LDFLAGS_SAVED="$LDFLAGS"
        LDFLAGS="$LDFLAGS $BOOST_LDFLAGS"
        export LDFLAGS
    
        AC_LANG_PUSH(C++)
        AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
            [[@%:@include <boost/version.hpp>]],
            [[
                #if BOOST_VERSION >= $WANT_BOOST_VERSION
                // Everything is okay
                #else
                #  error Boost version is too old
                #endif
            ]])],
            [AC_MSG_RESULT(yes)
             succeeded=yes
             found_system=yes
             ifelse([$2], , :, [$2])], [])

        AC_LANG_POP([C++])

        # if we found no boost with system layout we search for boost libraries
        # built and installed without the --layout=system option or for a
        # staged(not installed) version
        if test "x$succeeded" != xyes ; then
            _version=0
            if test "$ac_boost_path" != ""; then
                BOOST_LDFLAGS="-L$ac_boost_path/lib"
                if test -d "$ac_boost_path" && test -r "$ac_boost_path"; then
                    for i in `ls -d $ac_boost_path/include/boost-* 2>/dev/null`; do
                        _version_tmp=`echo $i | sed "s#$ac_boost_path##" | sed 's/\/include\/boost-//' | sed 's/_/./'`
                        V_CHECK=`expr $_version_tmp \> $_version`
                        if test "$V_CHECK" = "1" ; then
                            _version=$_version_tmp
                        fi
                        VERSION_UNDERSCORE=`echo $_version | sed 's/\./_/'`
                        BOOST_CPPFLAGS="-I$ac_boost_path/include/boost-$VERSION_UNDERSCORE"
                    done
                fi
            else
                for ac_boost_path in $ax_boost_install_prefix ; do
                    if test -d "$ac_boost_path" && test -r "$ac_boost_path"; then
                        for i in `ls -d $ac_boost_path/include/boost-* 2>/dev/null`; do
                            _version_tmp=`echo $i | sed "s#$ac_boost_path##" | sed 's/\/include\/boost-//' | sed 's/_/./'`
                            V_CHECK=`expr $_version_tmp \> $_version`
                            if test "$V_CHECK" = "1" ; then
                                _version=$_version_tmp
                                best_path=$ac_boost_path
                            fi
                        done
                    fi
                done
    
                VERSION_UNDERSCORE=`echo $_version | sed 's/\./_/'`
                BOOST_CPPFLAGS="-I$best_path/include/boost-$VERSION_UNDERSCORE"
                BOOST_LDFLAGS="-L$best_path/lib"
    
                if test "x$BOOST_ROOT" != "x"; then
                    if test -d "$BOOST_ROOT" && test -r "$BOOST_ROOT" && test -d "$BOOST_ROOT/stage/lib" && test -r "$BOOST_ROOT/stage/lib"; then
                        version_dir=`expr //$BOOST_ROOT : '.*/\(.*\)'`
                        stage_version=`echo $version_dir | sed 's/boost_//' | sed 's/_/./g'`
                        stage_version_shorten=`expr $stage_version : '\([[0-9]]*\.[[0-9]]*\)'`
                        V_CHECK=`expr $stage_version_shorten \>\= $_version`
                        if test "$V_CHECK" = "1" ; then
                            AC_MSG_NOTICE(We will use a staged boost library from $BOOST_ROOT)
                            BOOST_CPPFLAGS="-I$BOOST_ROOT"
                            BOOST_LDFLAGS="-L$BOOST_ROOT/stage/lib"
                        fi
                    fi
                fi
            fi
    
            CPPFLAGS="$CPPFLAGS $BOOST_CPPFLAGS"
            export CPPFLAGS
            LDFLAGS="$LDFLAGS $BOOST_LDFLAGS"
            export LDFLAGS
    
            AC_LANG_PUSH(C++)
            AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
                [[@%:@include <boost/version.hpp>]],
                [[
                    #if BOOST_VERSION >= $WANT_BOOST_VERSION
                       // Everything is okay
                    #else
                    #error Boost version is too old
                    #endif
                ]])],
                [AC_MSG_RESULT(yes ($_version))
                 succeeded=yes
                 ifelse([$2], , :, [$2])],
                [AC_MSG_RESULT(no ($_version))
                 ifelse([$3], , :, [$3])])
                AC_LANG_POP([C++])
            fi
    
            if test "$succeeded" != "yes" ; then
                if test "$_version" = "0" ; then
                    AC_MSG_ERROR([[We could not detect the boost libraries (version $boost_lib_version_req_shorten or higher). If you have a staged boost library (still not installed) please specify \$BOOST_ROOT in your environment and do not give a PATH to --with-boost option.  If you are sure you have boost installed, then check your version number looking in <boost/version.hpp>. See http://randspringer.de/boost for more documentation.]])
                else
                    AC_MSG_ERROR('Your boost libraries seems to old (version $_version).  We need at least $boost_lib_version_shorten')
                fi
            else

                AC_SUBST(BOOST_CPPFLAGS)
                AC_SUBST(BOOST_LDFLAGS)
                AC_DEFINE(HAVE_BOOST,,[define if the Boost library is available])

###############################################################################
#
# library prefix
#
if test "x"$_version != "x" ; then
    ax_boost_major_ver=`echo $_version | sed "s/_/./g" | sed -n "s/\([[0-9]]\{1,\}\)\..*/\1/p"`
    ax_boost_minor_ver=`echo $_version | sed "s/_/./g" | sed -n "s/[[0-9]]\{1,\}\.\([[0-9]]\{1,\}\).*/\1/p"`
else
    ax_boost_major_ver=0
    ax_boost_minor_ver=0
fi

if test "x"$CXX != x ; then
    ax_tmp_cc=$CXX
else
    ax_tmp_cc=$CC
fi

case $ax_tmp_cc in
gcc*|g++*)
    ax_cc=gcc
    if test $ax_boost_major_ver -gt 1 || test $ax_boost_minor_ver -gt 34 ; then
        ax_cc="$ax_cc"`$ax_tmp_cc -v 2>&1 | sed -n "s/.*[[Vv]]ersion[[ ]]\{1,\}\([[0-9]]\)\.\([[0-9]]\).*/\1\2/p"`
    fi
    ;;
icc*|icpc*)
    ax_cc=il ;;
borland*)
    ax_cc=bcb ;;
como*)
    ax_cc=como ;;
darwin*)
    ax_cc= ;;
edg*)
    ax_cc=edg ;;
kcc*)
    ax_cc=kcc ;;
kylix*)
    ax_cc=kylix ;;
mipspro*)
    ax_cc=mp ;;
sun*)
    ax_cc=sw ;;
tru64cxx*)
    ax_cc=tru ;;
vacpp*)
    ax_cc=vacpp ;;
esac

if test "x"$VERSION_UNDERSCORE != x ; then
    ax_lib_prefix_list="-$ax_cc-mt-$VERSION_UNDERSCORE \
                        -$ax_cc-mt-s-$VERSION_UNDERSCORE \
                        -$ax_cc-s-$VERSION_UNDERSCORE \
                        -$ax_cc-$VERSION_UNDERSCORE \
                        -$ax_cc-mt \
                        -$ax_cc-mt-s \
                        -$ax_cc-s \
                        -$ax_cc \
                        -mt"
else
    ax_lib_prefix_list="-$ax_cc-mt \
                        -$ax_cc-mt-s \
                        -$ax_cc-s \
                        -$ax_cc \
                        -mt"
fi

###############################################################################
#
# Boost.Filesystem
#
AC_CACHE_CHECK([whether the Boost::Filesystem library is available],
    ax_cv_boost_filesystem,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/filesystem/path.hpp>]],
            [[
                using namespace boost::filesystem;
                path my_path( "foo/bar/data.txt" );
            ]]),
        ax_cv_boost_filesystem=yes, ax_cv_boost_filesystem=no)
     AC_LANG_POP([C++])
    ]
)

if test "$ax_cv_boost_filesystem" = "yes"; then
    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_filesystem$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_FILESYSTEM_LIB="-l$ax_lib";AC_SUBST(BOOST_FILESYSTEM_LIB) link_filesystem="yes"; break],
            [link_filesystem="no"])
    done
    if test "x$link_filesystem" = xyes ; then
        AC_DEFINE(HAVE_BOOST_FILESYSTEM,,
            [define if the Boost::FILESYSTEM library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.ProgramOptions
#
AC_CACHE_CHECK(
    [whether the Boost::Program_Options library is available],
    ax_cv_boost_program_options,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/program_options.hpp>]],
            [[
                using namespace boost;
                program_options::options_description o("Generic options");
            ]]),
         ax_cv_boost_program_options=yes, ax_cv_boost_program_options=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_program_options" = xyes ; then
    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_program_options$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_PROGRAM_OPTIONS_LIB="-l$ax_lib";
            AC_SUBST(BOOST_PROGRAM_OPTIONS_LIB) link_program_options="yes";
            break],
            [link_program_options="no"])
    done
    if test "x$link_program_options" = xyes ; then
        AC_DEFINE(HAVE_BOOST_PROGRAM_OPTIONS,,
            [define if the Boost::PROGRAM_OPTIONS library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.Thread
#
AC_CACHE_CHECK(whether the Boost::Thread library is available,
    ax_cv_boost_thread,
    [
     AC_LANG_PUSH([C++])
     CXXFLAGS_SAVE=$CXXFLAGS
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/thread/thread.hpp>]],
            [[boost::thread t;]]),
        ax_cv_boost_thread=yes, ax_cv_boost_thread=no)
     CXXFLAGS=$CXXFLAGS_SAVE
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_thread" = xyes ; then
    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_thread$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_THREAD_LIB="-l$ax_lib";
            AC_SUBST(BOOST_THREAD_LIB) link_thread="yes"; break],
            [link_thread="no"])
    done
    if test "x$link_thread" = xyes ; then
        AC_SUBST(BOOST_CPPFLAGS)
        AC_DEFINE(HAVE_BOOST_THREAD,,
            [define if the Boost::THREAD library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.IOStreams
#
AC_CACHE_CHECK(whether the Boost::IOStreams library is available,
    ax_cv_boost_iostreams,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/iostreams/filtering_stream.hpp>
              @%:@include <boost/range/iterator_range.hpp>]],
            [[
                std::string  s = "Hello World!";
                namespace io = boost::iostreams;
                io::filtering_istream  in(boost::make_iterator_range(s));
            ]]),
        ax_cv_boost_iostreams=yes, ax_cv_boost_iostreams=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_iostreams" = xyes ; then
    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_iostreams$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_IOSTREAMS_LIB="-l$ax_lib";
            AC_SUBST(BOOST_IOSTREAMS_LIB) link_iostreams="yes";
            break], [link_iostreams="no"])
    done
    if test "x$link_iostreams" = xyes ; then
        AC_DEFINE(HAVE_BOOST_IOSTREAMS,,
            [define if the Boost::IOStreams library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.Serialization
#
AC_CACHE_CHECK(
    whether the Boost::Serialization library is available,
    ax_cv_boost_serialization,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <fstream>
              @%:@include <boost/archive/text_oarchive.hpp>
              @%:@include <boost/archive/text_iarchive.hpp>]],
            [[
                std::ofstream ofs("filename");
                boost::archive::text_oarchive oa(ofs);
            ]]),
        ax_cv_boost_serialization=yes, ax_cv_boost_serialization=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_serialization" = xyes ; then

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_serialization$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_SERIALIZATION_LIB="-l$ax_lib";
            AC_SUBST(BOOST_SERIALIZATION_LIB) link_serialization="yes";
            break],
            [link_serialization="no"])
    done
    if test "x$link_serialization" = xyes ; then
        AC_DEFINE(HAVE_BOOST_SERIALIZATION,,
            [define if the Boost::Serialization library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_wserialization$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_WSERIALIZATION_LIB="-l$ax_lib";
            AC_SUBST(BOOST_WSERIALIZATION_LIB) link_wserialization="yes";
            break],
            [link_wserialization="no"])
    done
    if test "x$link_wserialization" = "xno"; then
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.Signals
#
AC_CACHE_CHECK(whether the Boost::Signals library is available,
    ax_cv_boost_signals,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/signal.hpp>]],
            [[boost::signal<void ()> sig;]]),
            ax_cv_boost_signals=yes, ax_cv_boost_signals=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_signals" = xyes ; then

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_signals$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_SIGNALS_LIB="-l$ax_lib";
            AC_SUBST(BOOST_SIGNALS_LIB) link_signals="yes"; break],
            [link_signals="no"])
    done
    if test "x$link_signals" = xyes ; then
        AC_DEFINE(HAVE_BOOST_SIGNALS,,
            [define if the Boost::Signals library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.DateTime
#
AC_CACHE_CHECK(whether the Boost::Date_Time library is available,
    ax_cv_boost_date_time,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/date_time/gregorian/gregorian_types.hpp>]],
            [[using namespace boost::gregorian; date d(2002,Jan,10);]]),
        ax_cv_boost_date_time=yes, ax_cv_boost_date_time=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_date_time" = xyes ; then

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_date_time$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_DATE_TIME_LIB="-l$ax_lib";
            AC_SUBST(BOOST_DATE_TIME_LIB) link_thread="yes"; break],
            [link_thread="no"])
    done
    if test "x$link_thread" = xyes ; then
        AC_DEFINE(HAVE_BOOST_DATE_TIME,,
            [define if the Boost::Date_Time library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.Regex
#
AC_CACHE_CHECK(whether the Boost::Regex library is available,
    ax_cv_boost_regex,
    [AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/regex.hpp>]], [[boost::regex r();]]),
        ax_cv_boost_regex=yes, ax_cv_boost_regex=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_regex" = xyes ; then

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_regex$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_REGEX_LIB="-l$ax_lib";
            AC_SUBST(BOOST_REGEX_LIB) link_regex="yes"; break],
            [link_regex="no"])
    done
    if test "x$link_regex" = xyes ; then
        AC_DEFINE(HAVE_BOOST_REGEX,,
            [define if the Boost::Regex library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi

###############################################################################
#
# Boost.UnitTestramework
#
AC_CACHE_CHECK(whether the Boost::UnitTestFramework library is available,
    ax_cv_boost_unit_test_framework,
    [
     AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@define BOOST_AUTO_TEST_MAIN
              @%:@include <boost/test/auto_unit_test.hpp>]],
            [[ ]]),
        ax_cv_boost_unit_test_framework=yes, ax_cv_boost_unit_test_framework=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_unit_test_framework" = xyes ; then

    saved_ldflags="${LDFLAGS}"

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_unit_test_framework$ax_lib_prefix

        LDFLAGS="${LDFLAGS} -l$ax_lib"
        AC_CACHE_CHECK(link testing Boost::UnitTestFramework,
            ax_cv_boost_unit_test_framework_link,
            [
             AC_LANG_PUSH([C++])
             AC_LINK_IFELSE([
                 AC_LANG_PROGRAM(
                    [[@%:@include <boost/test/unit_test.hpp>
                        using boost::unit_test::test_suite;
                        test_suite* init_unit_test_suite(int, char**)
                        { return 0; }
                    ]],
                    [[ ]])
                ],
                link_unit_test_framework="yes", link_unit_test_framework="no")
             AC_LANG_POP([C++])
            ]
        )
        LDFLAGS="${saved_ldflags}"

        if test "x$link_unit_test_framework" = xyes ; then
            break
        fi
    done

    if test "x$ax_cv_boost_unit_test_framework" = xyes && test "x$link_unit_test_framework" = xyes ; then
        AC_DEFINE(HAVE_BOOST_UNIT_TEST_FRAMEWORK,,
            [define if the Boost::Unit_test_framework library is available])
        BOOST_UNIT_TEST_FRAMEWORK_LIB="-l$ax_lib"
        AC_SUBST(BOOST_UNIT_TEST_FRAMEWORK_LIB)
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi


###############################################################################
#
# Boost.Asio
#
AC_CACHE_CHECK(whether the Boost::Asio library is available,
    ax_cv_boost_asio,
    [AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/asio.hpp>]], [[]]),
        ax_cv_boost_asio=yes, ax_cv_boost_asio=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_asio" = xyes ; then
    AC_DEFINE(HAVE_BOOST_ASIO,,
        [define if the Boost::Asio library is available])
fi


###############################################################################
#
# Boost.System
#
AC_CACHE_CHECK(whether the Boost::System library is available,
    ax_cv_boost_system,
    [AC_LANG_PUSH([C++])
     AC_COMPILE_IFELSE(
        AC_LANG_PROGRAM(
            [[@%:@include <boost/system/system_error.hpp>]], [[]]),
        ax_cv_boost_system=yes, ax_cv_boost_system=no)
     AC_LANG_POP([C++])
    ]
)

if test "x$ax_cv_boost_system" = xyes ; then

    for ax_lib_prefix in $ax_lib_prefix_list " " ; do
        ax_lib=boost_system$ax_lib_prefix
        AC_CHECK_LIB($ax_lib, exit,
            [BOOST_SYSTEM_LIB="-l$ax_lib";
            AC_SUBST(BOOST_SYSTEM_LIB) link_system="yes"; break],
            [link_system="no"])
    done
    if test "x$link_system" = xyes ; then
        AC_DEFINE(HAVE_BOOST_SYSTEM,,
            [define if the Boost::System library is available])
    else
        AC_MSG_NOTICE(Could not link against $ax_lib !)
    fi
fi



        fi
        CPPFLAGS="$CPPFLAGS_SAVED"
        LDFLAGS="$LDFLAGS_SAVED"
    fi
])
