/*
 * }`vbgtH[`GWuSherryv
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	main.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	ɍXV
 */

/*---- CN[ht@C ----*/

#include <windows.h>			//!<WindowsAPI
#include <use_sherry.h>			//!<SherryCugp

/*---- }N` ----*/


/*---- \̒` ----*/


/*---- O[oϐ ----*/

shTexture	g_testTex;			//!<eNX`f[^
shTexture	g_testTex2;
shMesh		g_testMesh;			//!<bVf[^

shShaderProg g_shaderpg;		//!<VF[_vO

const char* source_vs= { "\
attribute vec3 vPos;\
attribute vec2 vTex;\
uniform mat4 u_worldViewProjMatrix;\
varying vec2 texCoord;\
void main(void) \
{ \
	texCoord = vTex;\
	gl_Position = u_worldViewProjMatrix * vec4(vPos,1); \
} "};

const char* source_fs = { "\
uniform sampler2D sampler2d;\
varying vec2 texCoord;\
void main (void) \
{ \
	gl_FragColor = texture2D(sampler2d, texCoord); \
} " };

// _vfz
shVertexElements mushroom_ve[] = {
	{0,SHVETYPE_FLOAT3,SHVEUSAGE_POSITION,"vPos"},
	{0,SHVETYPE_FLOAT2,SHVEUSAGE_NORMAL,"vTex"},
	SHVE_TMT()	//^[~l[^
};

static float rot = 0;
static float g_Scroll = 0;

/*---- X^eBbNvg^Cv錾 ----*/


/*---- X^eBbN֐ ----*/

/*
 *	void DrawFunc()
 *
 *	`֐FőptH[}XŌĂяo܂B
 */
void DrawFunc()
{
	// [Jϐ
	shMatrix drawmat, drawmat2, drawans;	// ϊp̍s

	// ʃNA
	shClear();

	// fobOEBhE̕`
	//shDebugDraw();

	//|S`
	{
		int ii;
		shVector3 eye,at,up;

		//ݒ
		eye.x = 0.0f;
		eye.y = 0.0f;
		eye.z = sinf(rot*0.02f)*1.6f+4.0f;
		at.x = 0.0f;
		at.y = 0.0f;
		at.z = 0.0f;
		up.x = 0.0f;
		up.y = 1.0f;
		up.z = 0.0f;
		
		shBeginShader(&g_shaderpg);

		// eNX`ݒ
		shSetTexture(&g_testTex2);

		// sϊ
		shMatrixIdentity(&drawans);	// Pʍs
		shMatrixPerspectiveFovRH(&drawmat,45,640.0f/480.0f,0.5f,20.0f);
		shLookAtMatrixRH(&drawmat2,&eye,&at,&up);
		shMatrixMultiply(&drawans,&drawmat2,&drawmat);
		shMatrixRotationYawPitchRoll(&drawmat2,rot,rot,rot);
		shMatrixMultiply(&drawans,&drawmat2,&drawans);

		for(ii = 0; ii < 9; ii++) {
			shMatrix drawmat_tran, drawmat_ans;

			const shVector3 pos[] = {
				{0,0,0},
				{0,0,1},
				{0,0,-1},
				{1,0,0},
				{-1,0,0},
				{0,0,2},
				{0,0,-2},
				{2,0,0},
				{-2,0,0},
				{0,1,0},
				{0,-1,0},
			};

			// sړ
			shMatrixTranslation(&drawmat_tran,pos[ii].x,pos[ii].y,pos[ii].z);
			// svZ
			shMatrixMultiply(&drawmat_ans,&drawmat_tran,&drawans);
			// s
			shUniformMatrix(&g_shaderpg,"u_worldViewProjMatrix",&drawmat_ans);

			// `
			shDrawMesh(&g_testMesh);
		}

		shEndShader(&g_shaderpg);
	}

	// UVW̐ݒ
	shSetSpriteTexCoord(g_Scroll, g_Scroll, 1.0f, 1.0f);
	// ʒu̐ݒ
	shSetSpritePosition(120.0f,160.0f,-0.5f);
	shSetSpriteSize(192.0f,192.0f);
	// eNX`ݒ
	shSetSpriteTexture(&g_testTex);
	shSetSpriteRotate(rot);
	// `
	shSpriteDraw();
	shPrintf(400, 100, "Sherry");
	shPrintf(400, 150, "test:%d", (int)rot);
	// fobOEBhE̕`
	//shDebugDraw();
}

/*
 *	void UpdateFunc()
 *
 *	XV֐F60fpsŌĂяo܂B
 */
void UpdateFunc()
{
	float posX, posY;

	// XN[̃eXg
	g_Scroll += 0.01f;
	if(g_Scroll >= 1.0f){
		g_Scroll = 0.0f;
	}

	if(shGetCursorPos(&posX,&posY)) {
		//Ă
		printf("F%f,%f\n",posX,posY);
	} else {
		//ĂȂ
	}

	rot+=5.0f;
	// [v܂B
}

/*
 *	int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
 *						char* lpszCmdLine, int nCmdShow )
 *
 *	Gg[|CgBX^[g܂B
 *@ R\[o߂main֐ɈꎞIɕύXB
 */
int main() 
//int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,
//					 char* szCmdLine, int nCmdShow )
 {
	// SherryCu
	shInitCreateSherry(GetModuleHandle(NULL),"SherryCu eXg",640,480,OpenGL);	// OpenGLgp

	// ֐Zbg
	shSetUpdateThread(60,UpdateFunc);	// XV
	shSetDrawThread(DrawFunc);			// `

	// XvCg
	if(shInitSprite())
		return 1;

	// fobOVXȅ
	if(shInitDebug())
		return 1;
	
	// fobOEBhE̐
	shCreateDebugWindow(100, 250, 100, 100);
	shCreateDebugWindow(300, 50, 300, 150);

	// Zbg
	shSetClear(0.2f,0.2f,0.2f,1,
		SH_CLS_COLOR_BUFFER|SH_CLS_DEPTH_BUFFER);	//NA

	// eNX`̍쐬
	shCreateTextureFromPNG(&g_testTex,shDCP("testtex_a.png"));
	shCreateTextureFromPNG(&g_testTex2,shDCP("mushroom.png"));

	// f̍쐬
	shCreateShader(&g_shaderpg,source_vs,source_fs,mushroom_ve);

	//shLoadMeshCOLLADA(&g_testMesh, "cube.dae");
	shLoadMeshCOLLADA(&g_testMesh, shDCP("mushroom.dae"));

	// SherryC[v
	shMainSherry();

	// eNX`̍폜
	shDeleteTexture(&g_testTex);
	shDeleteTexture(&g_testTex2);
	shDeleteMesh(&g_testMesh);

	// fobOVXȅI
	shExitDebug();

	// SherryCȕI
	shExitSherry();

	return 0;
 }
