﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright (C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shShader.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2010/11/16	|v0.01		|Cap5ule	|初回版
 */

#ifndef _SH_SHADER_H_
#define _SH_SHADER_H_

/*---- マクロ定義 ----*/

// VertexElements セマティック
typedef enum _enum_shveusage
{
    SHVEUSAGE_POSITION = 0,
    SHVEUSAGE_BLENDWEIGHT,   // 1
    SHVEUSAGE_BLENDINDICES,  // 2
    SHVEUSAGE_NORMAL,        // 3
    SHVEUSAGE_PSIZE,         // 4
    SHVEUSAGE_TEXCOORD,      // 5
    SHVEUSAGE_TANGENT,       // 6
    SHVEUSAGE_BINORMAL,      // 7
    SHVEUSAGE_TESSFACTOR,    // 8
    SHVEUSAGE_POSITIONT,     // 9
    SHVEUSAGE_COLOR,         // 10
    SHVEUSAGE_FOG,           // 11
    SHVEUSAGE_DEPTH,         // 12
    SHVEUSAGE_SAMPLE,        // 13
} SHVEUSAGE;

// VertexElements タイプ
typedef enum _enum_shvetype
{
    SHVETYPE_FLOAT1    =  0,  // 1D float expanded to (value, 0., 0., 1.)
    SHVETYPE_FLOAT2    =  1,  // 2D float expanded to (value, value, 0., 1.)
    SHVETYPE_FLOAT3    =  2,  // 3D float expanded to (value, value, value, 1.)
    SHVETYPE_FLOAT4    =  3,  // 4D float
    SHVETYPE_D3DCOLOR  =  4,  // 4D packed unsigned bytes mapped to 0. to 1. range
                                 // Input is in D3DCOLOR format (ARGB) expanded to (R, G, B, A)
    SHVETYPE_UBYTE4    =  5,  // 4D unsigned byte
    SHVETYPE_SHORT2    =  6,  // 2D signed short expanded to (value, value, 0., 1.)
    SHVETYPE_SHORT4    =  7,  // 4D signed short

    SHVETYPE_UBYTE4N   =  8,  // Each of 4 bytes is normalized by dividing to 255.0
    SHVETYPE_SHORT2N   =  9,  // 2D signed short normalized (v[0]/32767.0,v[1]/32767.0,0,1)
    SHVETYPE_SHORT4N   = 10,  // 4D signed short normalized (v[0]/32767.0,v[1]/32767.0,v[2]/32767.0,v[3]/32767.0)
    SHVETYPE_USHORT2N  = 11,  // 2D unsigned short normalized (v[0]/65535.0,v[1]/65535.0,0,1)
    SHVETYPE_USHORT4N  = 12,  // 4D unsigned short normalized (v[0]/65535.0,v[1]/65535.0,v[2]/65535.0,v[3]/65535.0)
    SHVETYPE_UDEC3     = 13,  // 3D unsigned 10 10 10 format expanded to (value, value, value, 1)
    SHVETYPE_DEC3N     = 14,  // 3D signed 10 10 10 format normalized and expanded to (v[0]/511.0, v[1]/511.0, v[2]/511.0, 1)
    SHVETYPE_FLOAT16_2 = 15,  // Two 16-bit floating point values, expanded to (value, value, 0, 1)
    SHVETYPE_FLOAT16_4 = 16,  // Four 16-bit floating point values
    SHVETYPE_UNUSED    = 17,  // When the type field in a decl is unused.
} SHVETYPE;

// shVertexElementsのターミネータ
#define SHVE_TMT() {0xFF,SHVETYPE_UNUSED,0,""}

/*---- 構造体定義 ----*/

#define SH_GLSL_VALUENAMENUM 128

/*---- 共用体定義 ----*/

/*
 * union _union_shaderProg
 * シェーダプログラム
 */
typedef union _union_shaderProg {
	GLuint shaderProg_gl;		//!<OpenGL シェーダプログラム
} shShaderProg;

/*
 * struct _tag_vertexElements
 * 頂点要素
 */
typedef struct _tag_vertexElements {
    unsigned short	stream;				//!<stream index
	unsigned char	type;				//!<type
	unsigned char	usage;				//!<usage
	unsigned char	valuename[SH_GLSL_VALUENAMENUM];	//!<valueName
} shVertexElements;

/*---- 外部グローバル変数 ----*/

extern shDrawMode g_sh_DrawMode;		//!<描画モード

/*---- プロトタイプ宣言 ----*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 * int shCreateShaderFromFile(shShaderProg* spg,
 *							const char* vspath, const char* fspath,
 *							shVertexElements* ve);
 *
 *	＜引数＞
 *　　shShaderProg* spg		: シェーダプログラム変数のポインタ
 *　　char* vspath			: 頂点シェーダファイルパス
 *　　char* fspath			: フラグメントシェーダファイルパス
 *　　shVertexElements* ve	: 頂点要素配列
 *	＜戻り値＞
 *　　int					: エラーコードが返ります
 *	＜説明＞
 *　　シェーダソースからシェーダプログラムを生成します。
 *　　頂点シェーダとフラグメントシェーダのソースコードをコンパイルし、
 *　　シェーダプログラムを生成します。[現在OpenGLのみ対応]
 */
int shCreateShaderFromFile(shShaderProg* spg,
							const char* vspath, const char* fspath,
							shVertexElements* ve);

/*
 * int shCreateShader(shShaderProg* spg,
 *						const char* vsbuf, const char* fsbuf,
 *						shVertexElements* ve);
 *
 *	＜引数＞
 *　　shShaderProg* spg		: シェーダプログラム変数のポインタ
 *　　char* vsbuf			: 頂点シェーダバッファ
 *　　char* fsbuf			: フラグメントシェーダバッファ
 *　　shVertexElements* ve	: 頂点要素配列
 *	＜戻り値＞
 *　　int					: エラーコードが返ります
 *	＜説明＞
 *　　シェーダソースからシェーダプログラムを生成します。
 *	　頂点シェーダとフラグメントシェーダのバッファをコンパイルし、
 *	　シェーダプログラムを生成します。[現在OpenGLのみ対応]
 */
int shCreateShader(shShaderProg* spg,
					const char* vsbuf, const char* fsbuf,
					shVertexElements* ve);

/*
 *	int shDeleteShader(shShaderProg* spg)
 *
 *	＜引数＞
 *　　shShaderProg* spg	: シェーダプログラム変数のポインタ
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　要らなくなったシェーダプログラムを削除します。
 */
int shDeleteShader(shShaderProg* spg);

/*
 *	int shBeginShader(shShaderProg* spg)
 *
 *	＜引数＞
 *		shShaderProg* spg	: シェーダプログラム変数のポインタ
 *	＜戻り値＞
 *		int					: エラーコードが返ります
 *	＜説明＞
 *		シェーダプログラムの適用を開始します。
 *		以降に呼び出される描画コマンドは、すべて適用されます。
 */
int shBeginShader(shShaderProg* spg);

/*
 *	int shEndShader(shShaderProg* spg)
 *
 *	＜引数＞
 *		shShaderProg* spg	: シェーダプログラム変数のポインタ
 *	＜戻り値＞
 *		int					: エラーコードが返ります
 *	＜説明＞
 *		シェーダプログラムの適用を解除します。
 */
int shEndShader(shShaderProg* spg);

/*
 *	int shUseVertexAttr(shShaderProg* spg,
 *					int index, int size, const void* pointer)
 *
 *	＜引数＞
 *		shShaderProg* spg	: シェーダプログラム変数のポインタ
 *		int index			: 要素番号
 *		int size			: 要素数１～４
 *		char* name			: 頂点情報名前
 *	＜戻り値＞
 *		int					: エラーコードが返ります
 *	＜説明＞
 *		頂点情報と要素番号をバインドする
 *		情報をシェーダへ送る際の関連付けをする
 */
int shUseVertexAttr(shShaderProg* spg,
					int index, int size, const void* pointer);

/*
 *	void shSetTexture(shTexture* texture)
 *
 *	＜引数＞
 *		shTexture* texture	: テクスチャ構造体
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		テクスチャを設定する。
 */
void shSetTexture(shTexture* texture);

/*
 *	void shUniformMatrix(shShaderProg* spg, const char* param
 *						 shMatrix* value)
 *
 *	＜引数＞
 *　　shShaderProg* spg	: シェーダプログラム変数のポインタ
 *　　char* param		: シェーダ内パラメータ名
 *　　shMatrix* value	: 行列ポインタ
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		Matrix型の変数を設定する。
 */
void shUniformMatrix(shShaderProg* spg, const char* param,
					 shMatrix* value);

/*
 *	void shUniformFloat(shShaderProg* spg, const char* param
 *						 float value)
 *
 *	＜引数＞
 *　　shShaderProg* spg	: シェーダプログラム変数のポインタ
 *　　char* param		: シェーダ内パラメータ名
 *　　float value		: 渡す値
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		Float型の変数を設定する。
 */
void shUniformFloat(shShaderProg* spg, const char* param,
					 float value);

/*
 *	void shUniformVector2(shShaderProg* spg, const char* param
 *						  shVector2* value)
 *
 *	＜引数＞
 *　　shShaderProg* spg	: シェーダプログラム変数のポインタ
 *　　char* param		: シェーダ内パラメータ名
 *　　shVector2* value	: ベクトル２ポインタ
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		Vector2型の変数を設定する。
 */
void shUniformVector2(shShaderProg* spg, const char* param,
					  shVector2* value);

/*
 *	void shUniformVector3(shShaderProg* spg, const char* param
 *						  shVector3* value)
 *
 *	＜引数＞
 *　　shShaderProg* spg	: シェーダプログラム変数のポインタ
 *　　char* param		: シェーダ内パラメータ名
 *　　shVector3* value	: ベクトル３ポインタ
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		Vector3型の変数を設定する。
 */
void shUniformVector3(shShaderProg* spg, const char* param,
					  shVector3* value);


#ifdef __cplusplus
}
#endif

#endif /*_SH_SHADER_H_*/
