﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shMesh.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2010/12/14	|v0.01		|Cap5ule	|初回版
 */

#ifndef _SH_MESH_H_
#define _SH_MESH_H_

/*---- マクロ定義 ----*/

#define MAX_SHCHARLENGTH	64		//!<char最大文字数(byte)
//shColladaInfo -> flags用フラグ
#define CI_SHFLAGS_COLLADA			0x00000001
#define CI_SHFLAGS_ASSET			0x00000002
#define CISHFLAGS_LIBGEOMETRIES		0x00000004
#define CISHFLAGS_GEOMETRY			0x00000008
#define CISHFLAGS_MESH				0x0000000F
#define CISHFLAGS_SOURCE			0x00000011
#define CISHFLAGS_FLOATARRAY		0x00000012
#define CISHFLAGS_TECHCOMMON		0x00000014
#define CISHFLAGS_ACCESSOR			0x00000018
#define CISHFLAGS_PARAM				0x0000001F
#define CISHFLAGS_VERTICES			0x00000021
#define CISHFLAGS_TRIANGLES			0x00000022
#define CISHFLAGS_INPUT				0x00000024
#define CISHFLAGS_P					0x00000028

/*---- 列挙型定義 ----*/

typedef enum _shDataType {
	floatType,
} shDataType;

/*---- 構造体定義 ----*/

/********************************************************************************
 *	３Ｄモデルメッシュ															*
 ********************************************************************************/
typedef struct _shmesh
{
	shVector3* vartex_p;	//!<頂点位置
	shVector2* vartex_uv;	//!<ＵＶ座標
	unsigned short* index;	//!<結線
	int vertex_size;		//!<頂点数
	int face_size;			//!<ポリゴン数
} shMesh;

/********************************************************************************
 *	COLLADA解析用情報															*
 ********************************************************************************/
typedef struct _shcolladainfo {
	unsigned long flags;			//!<入れ子状態フラグ
	char version[MAX_SHCHARLENGTH];	//!<COLLADAのバージョン
	//<library_geometries><geometry>
	struct _shGeometriesNode {
		char id[MAX_SHCHARLENGTH];
		char name[MAX_SHCHARLENGTH];
		//<mesh><source>
		struct _shSourceNode {
			char id[MAX_SHCHARLENGTH];
			char id_array[MAX_SHCHARLENGTH];
			unsigned short count;
			shDataType arrayType;
			union {
				float* float_array;			//!<float_array>
			};
			//<technique_common><accessor>
			struct _shAccessor {
				char id_source[MAX_SHCHARLENGTH];
				unsigned short count;
				unsigned short stride;	//!<param数
				//<param>
				char* param_name;
				shDataType* param_type;
			} shAccessor;
			struct _shSourceNode* next;
		} *shSourceNode_first;				//!<ソース[ノード]
		//<vertices>
		struct _shVertices {
			char id[MAX_SHCHARLENGTH];
			//<input>
			unsigned short inputNum;
			struct _shVInputNode {
				char semantic[MAX_SHCHARLENGTH];
				char id_source[MAX_SHCHARLENGTH];
				struct _shVInputNode* next;
			} *shVInputNode_first;
		} shVertices;
		//<triangles>
		struct _shTriangles {
			unsigned short count;
			unsigned short* p;
			//<input>
			unsigned short inputNum;
			struct _shTInputNode {
				char semantic[MAX_SHCHARLENGTH];
				char id_source[MAX_SHCHARLENGTH];
				unsigned short offset;
				struct _shTInputNode* next;
			} *shTInputNode_first;
		} shTriangles;
		struct _shGeometriesNode* next;
	} *shGeometriesNode_first;				//!<ジオメトリ[ノード]

	// 処理中のタグを保存（テキストの判断用）
	char tagName[MAX_SHCHARLENGTH];
	// 処理中のカウンタ
	int count_cur;
	// 処理中の内容
	int proc_cur;		//!<1:shVertices, 2:shTriangles

	// カレントノード情報
	struct _shGeometriesNode* shGeometriesNode_cur;
	struct _shSourceNode* shSourceNode_cur;

	// 要素のテキスト
	union {
		float* float_array;
		unsigned short* p_array;
	} array_cur;

} shColladaInfo;

/*---- 外部グローバル変数 ----*/

extern shDrawMode g_sh_DrawMode;		//!<描画モード

/*---- プロトタイプ宣言 ----*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	int shCreateMeshArray(shMesh* pMesh, float* p, float* uv, unsigned short* idx,
 *					  int vsize, int idxsize);
 *	＜引数＞
 *　　shMesh* pMesh			: メッシュデータポインタ
 *　　float* p				: 頂点データ配列
 *　　float* uv				: ＵＶデータ配列
 *　　unsigned short* idx	: 結線配列
 *　　float* vsize			: 頂点数
 *　　float* idxsize		: ポリゴン数
 *	＜戻り値＞
 *　　int					: エラーコードが返ります
 *	＜説明＞
 *　　用意された配列からメッシュデータを作成します。
 */
int shCreateMeshArray(shMesh* pMesh, float* p, float* uv, unsigned short* idx,
					  int vsize, int idxsize);

/*
 *	int shLoadMeshCOLLADA(shMesh* mesh, const char* daedoc)	
 *
 *	＜引数＞
 *　　shMesh* pMesh		: メッシュデータポインタ
 *　　char*				: daeドキュメントパス
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　COLLADAフォーマットからデータを読み込みます。
 *　　※形式によっては対応していない場合があります。
 */
int shLoadMeshCOLLADA(shMesh* pMesh, const char* daedoc);

/*
 *	int shCreateMesh(shMesh* pMesh, shVector3* vp, shVector2* vuv,
 *				 unsigned short* idx, int vsize, int fsize);
 *
 *	＜引数＞
 *　　shMesh* pMesh			: メッシュデータポインタ
 *　　shVector3* vp			: 頂点情報
 *　　shVector2* vuv		: ＵＶ座標
 *　　unsigned short* idx	: 結線
 *　　int vsize				: 頂点数
 *　　int fsize				: ポリゴン数
 *	＜戻り値＞
 *　　int					: エラーコードが返ります
 *	＜説明＞
 *　　メッシュデータを構成データから直接作る。
 */
int shCreateMesh(shMesh* pMesh, shVector3* vp, shVector2* vuv,
				 unsigned short* idx, int vsize, int fsize);

/*
 *	int shDrawMesh(shMesh* mesh)
 *
 *	＜引数＞
 *　　shMesh* pMesh		: メッシュデータポインタ
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　メッシュデータを描画します。
 */
int shDrawMesh(shMesh* pMesh);

/*
 *	int shDeleteMesh(shMesh* mesh)
 *
 *	＜引数＞
 *　　shMesh* pMesh		: メッシュデータポインタ
 *	＜戻り値＞
 *　　int				: エラーコードが返ります
 *	＜説明＞
 *　　メッシュデータを解放し削除する。
 */
int shDeleteMesh(shMesh* pMesh);

#ifdef __cplusplus
}
#endif

#endif /*_SH_MESH_H_*/
