﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shDevice.c
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 *
 *	Date		|Version	|Author		|Summary
 *	2010/11/16	|v0.01		|Cap5ule	|初回版
 */

#ifndef _SH_DEVICE_H_
#define _SH_DEVICE_H_

/*---- マクロ定義 ----*/

#define SH_CLS_COLOR_BUFFER		0x00000001
#define SH_CLS_DEPTH_BUFFER		0x00000002
#define SH_CLS_STENCIL_BUFFER	0x00000004

/*---- 構造体定義 ----*/



/*---- 外部グローバル変数 ----*/

extern shDrawMode g_sh_DrawMode;		//!<描画モード
extern unsigned int g_sh_clsFlag;		//!<クリアターゲットフラグ

/*---- プロトタイプ宣言 ----*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	void shClear()
 *
 *	＜引数＞
 *　　なし
 *	＜戻り値＞
 *　　なし
 *	＜説明＞
 *　　描画バッファのクリア・消去を行います。
 *　　描画関数の中で行うことをお勧めします。
 */
void shClear();

/*
 *	void shSetClear(float r, float g, float b, float a, unsigned int flag)
 *
 *	＜引数＞
 *		float r			: Ｒ色
 *		float g			: Ｇ色
 *		float b			: Ｂ色
 *		float a			: Ａ色
 *		float flag		: クリアフラグ
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		描画バッファの消去する際の色と内容を設定をします。
 */
void shSetClear(float r, float g, float b, float a, unsigned int flag);

#ifdef __cplusplus
}
#endif

#endif /*_SH_DRAW_H_*/
