/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shApplication_osx_sys.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2011/1/17	|v0.01		|Cap5ule	|初回版
 */

#ifndef _SH_APPLICATION_OSX_SYS_H_
#define _SH_APPLICATION_OSX_SYS_H_

/*
 *	@interface GLContextView : UIView 
 *
 *	＜説明＞
 *　　*****
 */
@interface GLContextView : NSView {    
@private
    bool animating;					//!<アニメーションフラグ
	double animationInterval;		//!<間隔
	
    NSTimer *animationTimer;		//!<タイマー
	
	NSOpenGLContext* m_GLcontext;	//!<コンテキスト
}

@property (readonly, nonatomic, getter=isAnimating) bool animating;

- (void)setAnimationInterval:(double)interval;
- (void)startAnimation;
- (void)stopAnimation;
- (void)drawView:(id)sender;

@end	/*GLContextView*/


/*
 *	@interface AppDelegate : NSObject<UIApplicationDelegate>
 *
 *	＜説明＞
 *　　*****
 */
@interface AppDelegate : NSObject<NSApplicationDelegate> {
@private
    NSWindow* m_window;					//!<ウィンドウ
}

@property (assign) IBOutlet NSWindow* m_window;

@end	/*AppDelegate*/

#endif	/*_SH_APPLICATION_OSX_SYS_H_*/
