﻿/*
 * マルチプラットフォーム描画エンジン「Sherry」
 * Copyright(C) 2010-2011 SherryProject. all rights reserved.
 *
 * The MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

/*
 *	shApplication_android.h
 *		Copyright (C) 2010-2011 Cap5ule. all rights reserved.
 * 
 *	Date		|Version	|Author		|Summary
 *	2011/01/03	|v0.01		|onakah		|初回版
 */

#ifndef _SH_APPLICATION_ANDROID_H_
#define _SH_APPLICATION_ANDROID_H_

/*---- マクロ定義 ----*/

#define WINDOWCLASS_NAME "sherryengine"		//!<ウィンドウクラスの名前

/*---- 構造体定義 ----*/


/*---- 列挙型定義 ----*/

/*
 *	typedef enum _enum_drawmode shDrawMode
 * 
 *	＜説明＞
 *		どのＡＰＩを使用するかの描画モードの列挙型
 */

 typedef enum _enum_shDrawMode {
	OpenGL,			//!<OpenGL 3Dライブラリ
	SH_DRAWMODE_NUM,
} shDrawMode;


/*---- 外部グローバル変数 ----*/


/*---- プロトタイプ宣言 ----*/

#ifdef __cplusplus
extern "C" {
#endif

/*
 *	int shInitCreateSherry(const char* title,
 *							 int width, int height, int cmd)
 *
 *	＜引数＞
 *		char* title		: ウィンドウタイトル
 *		int	width		: ウィンドウ幅サイズ
 *		int height		: ウィンドウ縦サイズ
 *		shDrawMode mode : 描画モード
 *	＜戻り値＞
 *		int				: エラーコードが返ります
 *	＜説明＞
 *		描画エンジン「Sherry」を使用するための初期化とウィンドウの作成を
 *		行います。必ず必要となる。
 */
int shInitCreateSherry(const char* title,
						int width, int height, shDrawMode mode);

/*
 *	int shExitSherry()
 *
 *	＜引数＞
 *		なし
 *	＜戻り値＞
 *		int				: エラーコードが返ります
 *	＜説明＞
 *　	描画エンジン「Sherry」の終了をさせます。
 *		描画エンジン「Sherry」を使用した際に使ったメモリを解放します。
 *		アプリケーションの終了時に必ず呼んでください。
 */
int shExitSherry();

/*
 *	void shMainSherry()
 *
 *	＜引数＞
 *		なし
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		描画エンジン「Sherry」メインループ関数です。
 *		この関数を呼び出すことで、プログラムはイベントの待ち受け状態になります。
 */
void shMainSherry();

/*
 *	int shSetUpdateThread(int framerate, void(*thd)())
 *
 *	＜引数＞
 *		int	framerate	: 更新間隔（フレームレート）
 *		void(*thd)()	: 更新用関数のポインタ：使用しない場合は[NULL]
 *	＜戻り値＞
 *		int				: エラーコードが返ります
 *	＜説明＞
 *		更新関数を別スレッドとして動作します。
 *		そうすることで一定のアニメーションを可能にします。
 */
int shSetUpdateThread(int framerate, void(*thd)());

/*
 *	int shSetDrawThread(void(*thd)())
 *
 *	＜引数＞
 *		void(*thd)()	: 描画用関数のポインタ：使用しない場合は[NULL]
 *	＜戻り値＞
 *		int				: エラーコードが返ります
 *	＜説明＞
 *		描画関数を別スレッドとして動作します。
 *		そうすることで最高のパフォーマンスの提供を可能にします。
 */
int shSetDrawThread(void(*thd)());

/*
 *	void shDCP()
 *
 *	＜引数＞
 *		char* filePath	: 変換するファイルパス
 *	＜戻り値＞
 *		char*			: 変換されたコンテンツのパスを返す
 *	＜説明＞
 *　　DeviceContentsPathの省略形
 *　　デバイス等のハードウェア内部パスの違いをなくし、
 *　　コンテンツパスへとつなげる統一性を図る関数です。
 */
char* shDCP(const char* filePath);

/*
 *	float shGetUpdateFPS()
 *
 *	＜引数＞
 *		なし
 *	＜戻り値＞
 *		float			: 平均更新回数
 *	＜説明＞
 *		１秒間あたりの更新回数を取得する。
 */
float shGetUpdateFPS();

/*
 *	float shGetDrawFPS()
 *
 *	＜引数＞
 *		なし
 *	＜戻り値＞
 *		float			: 平均描画回数
 *	＜説明＞
 *		１秒間あたりの描画回数を取得する。
 */
float shGetDrawFPS();

/*
 *	void shSetCDP(char* path)
 *
 *	＜引数＞
 *		char* path	: カレントディレクトリパス
 *	＜戻り値＞
 *		なし
 *	＜説明＞
 *		カレントディレクトリパスを設定する。
 */
void shSetCDP(char* path);

/*
 *	int shGetCursorPosX(float* x, float* y)
 *
 *	＜引数＞
 *　　float* x		: カーソルのＸ座標を入れる
 *　　float* y		: カーソルのＹ座標を入れる
 *	＜戻り値＞
 *　　int			: 押されている場合は１が返り、押されてない場合は０が返ります。
 *	＜説明＞
 *　　基本共通入力取得用関数。
 *　　ＰＣの場合は、カーソル位置を取得でき、
 *　　スマートフォンの場合は、押されている位置を取得できる。※実用に使うべきでない。
 */
int shGetCursorPos(float* x, float* y);


#ifdef __cplusplus
}
#endif

#endif /*_SH_APPLICATION_ANDROID_H_*/
