﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: Program.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Windows.Forms;

namespace Bis5Products.SharpWebBrowser {
    static class Program {
        internal delegate void SaveBookmark();
        internal delegate bool SaveSettings();
        internal static event SaveBookmark OnSaveBookmark;
        internal static event SaveSettings OnSaveSettings;
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main(string[] args) {
            isCalledThreadException = false;
            Application.SetUnhandledExceptionMode(UnhandledExceptionMode.CatchException);
            Application.ThreadException += new System.Threading.ThreadExceptionEventHandler(Application_ThreadException);
            try {
                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new SharpWebBrowser.MainForm(args));
            } catch (Exception ex) {
                var errordialog = new SharpWebBrowser.ErrorReportingDialog(ex);
                var rslt = errordialog.ShowDialog();

                // Try to save settings & bookmark items
                try { OnSaveBookmark(); } catch { }
                try { OnSaveSettings(); } catch { }

                if (rslt == DialogResult.Yes)
                    Application.Restart();
                else
                    Application.Exit();
            }
        }

        static void Application_ThreadException(object sender, System.Threading.ThreadExceptionEventArgs e) {
            isCalledThreadException = true;
            var errordialog = new SharpWebBrowser.ErrorReportingDialog(e.Exception);
            var rslt = errordialog.ShowDialog();

            // Try to save settings & bookmark items
            try { OnSaveBookmark(); } catch { }
            try { OnSaveSettings(); } catch { }

            if (rslt == DialogResult.Yes)
                Application.Restart();
            else
                Application.Exit();
        }

        internal static bool isCalledThreadException { get; set; }
    }
}