﻿///////////////////////////////////////////////////////////////////////////////
// This file is part of SharpWebBrowser.
///////////////////////////////////////////////////////////////////////////////
// Copyright (C) 2009-2011 bis5 <bis5@users.sourceforge.jp>
// All rights reserved.
///////////////////////////////////////////////////////////////////////////////
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the Microsoft Public Licence (Ms-PL) as published by 
// Microsoft Corp.
//
// You should have received a copy of the Microsoft Public License along 
// with this program. 
// If not, see <http://www.microsoft.com/opensource/licenses.mspx>
//
///////////////////////////////////////////////////////////////////////////////
//
// File information
// Name: PluginInfo.cs, PluginInfo.Designer.cs
// Author: bis5
//
///////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Windows.Forms;


namespace Bis5Products.SharpWebBrowser.Dialogs {
    public partial class PluginInfo : Form {
        /// <summary>
        /// <see cref="Bis5Products.SharpWebBrpwser.Dialogs.PluginInfo"/>の新しいインスタンスを開始します。
        /// </summary>
        internal PluginInfo(LanguageManager lmgr) {
            InitializeComponent();
            lnSel = lmgr;
            lnSel.AppendDelegate(SetLanguage);
            SetLanguage();
        }

        private LanguageManager lnSel;
        /// <summary>
        /// 言語定数をロードします。このクラスで読み込む定数のプレフィックスはCore_PluginInfo_です。
        /// </summary>
        private void SetLanguage() {
            this.Text = lnSel.GetValue("Core_PluginInfo_Text");
            this.columnAuthor.Text = lnSel.GetValue("Core_PluginInfo_columnAuthor.Text");
            this.columnFileName.Text = lnSel.GetValue("Core_PluginInfo_columnFileName.Text");
            this.columnName.Text = lnSel.GetValue("Core_PluginInfo_columnName.Text");
            this.columnVersion.Text = lnSel.GetValue("Core_PluginInfo_columnVersion.Text");
            this.button1.Text = lnSel.GetValue("Generic_OK");
        }

        /// <summary>
        /// SimpleWebBrowserプラグイン情報ダイアログにプラグインの情報を登録します。
        /// </summary>
        /// <param name="title">プラグイン名称</param>
        /// <param name="version">プラグインバージョンを表す文字列</param>
        /// <param name="author">プラグイン作者</param>
        /// <param name="filename">プラグインクラスライブラリファイル名</param>
        public void AddVersionInfo(string title, string version, string author, string filename) {
            ListViewItem item = new ListViewItem(new string[] { title, version, author, filename });
            if (!listView1.Items.Contains(item)) { listView1.Items.Add(item); }
        }

    }//class PluginInfo
}