package jp.ac.titech.sharp4k.cuten;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

import com.google.inject.Inject;

public class SQLHelper extends SQLiteOpenHelper {
	final static private int DB_VERSION = 1;

	@Inject
	@DBName
	private static String dbName;

	public SQLHelper(Context context) {
		super(context, dbName, null, DB_VERSION);
	}

	@Override
	public void onCreate(SQLiteDatabase db) {
		db.execSQL("CREATE TABLE \"teachers\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"icon_path\" varchar(255));");
		db.execSQL("CREATE TABLE \"lectures\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"teacher_id\" integer);");
		db.execSQL("CREATE TABLE \"tasks\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"lecture_id\" integer);");
		db.execSQL("CREATE TABLE \"apks\" (\"id\" INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"name\" varchar(255), \"revision\" integer, \"task_id\" integer);");
		db.execSQL("CREATE TABLE \"selected_lectures\" (\"id\" INTEGER PRIMARY KEY NOT NULL);");
		db.execSQL("CREATE TABLE \"achievements\" (\"task_id\"  INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, \"result\" varchar(255),\"submitted\" boolean);");
		db.execSQL("CREATE INDEX \"index_lectures_on_teacher_id\" ON \"lectures\" (\"teacher_id\");");
		db.execSQL("CREATE INDEX \"index_tasks_on_lecture_id\" ON \"tasks\" (\"lecture_id\");");
		db.execSQL("CREATE INDEX \"index_apks_on_task_id\" ON \"apks\" (\"task_id\");");
		db.execSQL("CREATE INDEX \"index_achievements_on_task_id\" ON \"achievements\" (\"task_id\");");
	}

	@Override
	public void onUpgrade(SQLiteDatabase arg0, int arg1, int arg2) {

	}

}
