package jp.ac.titech.sharp4k.cuten;

import java.util.Iterator;
import java.util.concurrent.BlockingQueue;

public class AchievementsSender {
	private static BlockingQueue<Achievement> queue;

	public static void init(BlockingQueue<Achievement> q) {
		queue = q;
	}

	private static void removeDup(Achievement achievement) {
		synchronized (queue) {
			for (Iterator<Achievement> it = queue.iterator(); it.hasNext();) {
				Achievement a = it.next();
				if (a.getTask().getId() == achievement.getTask().getId()) {
					it.remove();
					break;
				}
			}
		}
	}

	public static void add(Achievement achievement) {
		removeDup(achievement);
		queue.add(achievement);
	}
}
