/*
 * Decompiled with CFR 0.152.
 */
package roboguice.inject;

import android.app.Application;
import android.content.Context;
import android.content.ContextWrapper;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import roboguice.util.RoboContext;

public class ContextScope
implements Scope {
    protected ThreadLocal<Stack<WeakReference<Context>>> contextThreadLocal = new ThreadLocal();
    protected Map<Key<?>, Object> applicationScopedObjects = new HashMap();
    protected Application application;

    public ContextScope(Application application) {
        this.application = application;
        this.enter((Context)application);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter(Context context) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Stack<WeakReference<Context>> stack = this.getContextStack();
            Map<Key<?>, Object> map = this.getScopedObjectMap(context);
            stack.push(new WeakReference<Context>(context));
            Class<?> c = context.getClass();
            do {
                map.put(Key.get(c), context);
            } while ((c = c.getSuperclass()) != Object.class);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(Context context) {
        Class<ContextScope> clazz = ContextScope.class;
        synchronized (ContextScope.class) {
            Stack<WeakReference<Context>> stack = this.getContextStack();
            Context c = (Context)stack.pop().get();
            if (c != null && c != context) {
                throw new IllegalArgumentException(String.format("Scope for %s must be opened before it can be closed", context));
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public <T> Provider<T> scope(final Key<T> key, final Provider<T> unscoped) {
        return new Provider<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public T get() {
                Class<ContextScope> clazz = ContextScope.class;
                synchronized (ContextScope.class) {
                    Stack<WeakReference<Context>> stack = ContextScope.this.getContextStack();
                    Context context = (Context)stack.peek().get();
                    Map<Key<?>, Object> objectsForScope = ContextScope.this.getScopedObjectMap(context);
                    if (objectsForScope == null) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return null;
                    }
                    Object current = objectsForScope.get(key);
                    if (current == null && !objectsForScope.containsKey(key)) {
                        current = unscoped.get();
                        objectsForScope.put(key, current);
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return current;
                }
            }
        };
    }

    public Stack<WeakReference<Context>> getContextStack() {
        Stack<WeakReference<Object>> stack = this.contextThreadLocal.get();
        if (stack == null) {
            stack = new Stack();
            this.contextThreadLocal.set(stack);
        }
        return stack;
    }

    protected Map<Key<?>, Object> getScopedObjectMap(Context origContext) {
        Context context = origContext;
        while (!(context instanceof RoboContext) && !(context instanceof Application) && context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        if (context instanceof Application) {
            return this.applicationScopedObjects;
        }
        if (!(context instanceof RoboContext)) {
            throw new IllegalArgumentException(String.format("%s does not appear to be a RoboGuice context (instanceof RoboContext)", origContext));
        }
        return ((RoboContext)context).getScopedObjectMap();
    }
}

