package jp.ac.titech.sharp4k.cuten.test;

import java.net.ConnectException;

import jp.ac.titech.sharp4k.cuten.DownloadActivity;
import jp.ac.titech.sharp4k.cuten.HttpAPIClient;
import jp.ac.titech.sharp4k.cuten.HttpResponseListener;

import com.google.inject.AbstractModule;

import android.widget.ListAdapter;
import android.widget.ListView;

public class AbnormalDownloadActivityTest extends
		ActivityTestCaseWithRobo<DownloadActivity> {
	static class AbnormalModule extends AbstractModule {
		@Override
		protected void configure() {
			bind(HttpAPIClient.class).to(AbnormalHttpAPIClient.class);
		}
	}

	static class AbnormalHttpAPIClient extends NullHttpAPIClient {
		@Override
		public void getLectures(HttpResponseListener listener) {
			listener.preExec();
			listener.onFailure(new ConnectException());
			listener.postExec();
		}
	}

	private DownloadActivity activity;

	public AbnormalDownloadActivityTest() {
		super(DownloadActivity.class, new AbnormalModule());
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();
		activity = getActivity();
	}

	public void testShowLocalLecturesEvenIfNetworkFailed() throws Exception {
		waitUI();
		ListView lectureList = (ListView) activity
				.findViewById(jp.ac.titech.sharp4k.cuten.R.id.lectureList);
		assertNotNull(lectureList);
		ListAdapter adapter = lectureList.getAdapter();
		assertNotNull(adapter);
		assertEquals(0, adapter.getCount());
	}
}
