package jp.ac.titech.sharp4k.cuten;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import android.content.Context;

public class Token {
	private static final String TOKEN_FILE_NAME = "token.txt";

	public static boolean save(String s, Context a) {
		try {
			OutputStream out = a.openFileOutput(TOKEN_FILE_NAME,
					Context.MODE_PRIVATE);
			PrintWriter writer = new PrintWriter(new OutputStreamWriter(out,
					"UTF-8"));
			writer.append(s);
			writer.close();
			return true;
		} catch (IOException e) {
			return false;
		}
	}

	public static String load(Context a) {
		try {
			InputStream in = a.openFileInput(TOKEN_FILE_NAME);
			BufferedReader reader = new BufferedReader(new InputStreamReader(
					in, "UTF-8"));
			String s = reader.readLine();
			reader.close();
			return s;
		} catch (IOException e) {
			return null;
		}
	}

	public static boolean isExist(Context a) {
		return a.getFileStreamPath(TOKEN_FILE_NAME).exists();
	}

	public static boolean delete(Context a) {
		return a.deleteFile(TOKEN_FILE_NAME);
	}
}
