package jp.ac.titech.sharp4k.cuten;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;

public class Task {
	private int id;
	private String name;
	private Lecture lecture;

	public Task(int id, String name, Lecture lecture) {
		this.id = id;
		this.name = name;
		this.lecture = lecture;
	}

	public int getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public Lecture getLecture() {
		return lecture;
	}

	public long save(SQLiteDatabase db) {
		ContentValues row = new ContentValues();
		row.put("id", getId());
		row.put("name", getName());
		row.put("lecture_id", getLecture().getId());
		return db.insertWithOnConflict("tasks", null, row,
				SQLiteDatabase.CONFLICT_IGNORE);
	}

	public static Task find(SQLiteDatabase db, int id) {
		Cursor c = db
				.rawQuery(
						"SELECT tasks.name, lectures.id, lectures.name, teachers.id, teachers.name"
								+ " FROM teachers, lectures, tasks"
								+ " WHERE tasks.id = ?"
								+ " AND tasks.lecture_id = lectures.id"
								+ " AND lectures.teacher_id = teachers.id"
								+ " LIMIT 1",
						new String[] { String.valueOf(id) });
		if (c.moveToNext()) {
			Teacher t = new Teacher(c.getInt(3), c.getString(4));
			Lecture l = new Lecture(c.getInt(1), c.getString(2), t);
			String name = c.getString(0);
			c.close();
			return new Task(id, name, l);
		} else {
			// not found
			c.close();
			return null;
		}
	}

	public Apk findLatestApk(SQLiteDatabase db) {
		Cursor c = db.rawQuery("SELECT apks.id, apks.revision, apks.name"
				+ " FROM apks WHERE apks.task_id = ?"
				+ " ORDER BY apks.revision DESC LIMIT 1",
				new String[] { String.valueOf(getId()) });
		if (c.moveToNext()) {
			Apk apk = new Apk(c.getInt(0), c.getInt(1), c.getString(2), this);
			c.close();
			return apk;
		} else {
			// not found
			c.close();
			return null;
		}
	}
}
