package jp.ac.titech.sharp4k.cuten.sampletask;

import jp.ac.titech.sharp4k.cuten.BaseApp;
import jp.ac.titech.sharp4k.cuten.R;
import android.content.Context;
import android.content.res.Resources;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.widget.TextView;

public class ECCTask extends BaseApp {
	private Context ctx;
	private Resources res;
	MatrixView mv;
	int[] result;

	@Override
	protected View createView(Context ctx, Resources res) {
		this.ctx = ctx;
		this.res = res;
		result = new int[1];
		// set layout
		RelativeLayout reLay = new RelativeLayout(ctx);
		// textview
		TextView tv = new TextView(ctx);
		tv.setText(res.getString(R.string.text));
		tv.setTextSize(30);
		tv.setId(1);
		RelativeLayout.LayoutParams tvParam = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.WRAP_CONTENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		tvParam.addRule(RelativeLayout.ALIGN_PARENT_TOP, -1);
		tvParam.addRule(RelativeLayout.ALIGN_PARENT_LEFT, -1);
		reLay.addView(tv, tvParam);
		// reset button
		Button reset = new Button(ctx);
		reset.setText("reset");
		reset.setId(3);
		RelativeLayout.LayoutParams resetParam = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.WRAP_CONTENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		resetParam.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, -1);
		resetParam.addRule(RelativeLayout.ALIGN_PARENT_LEFT, -1);
		reLay.addView(reset, resetParam);
		// finish button
		Button finish = new Button(ctx);
		finish.setText("finish");
		finish.setId(4);
		RelativeLayout.LayoutParams finishParam = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.WRAP_CONTENT,
				ViewGroup.LayoutParams.WRAP_CONTENT);
		finishParam.addRule(RelativeLayout.ALIGN_PARENT_BOTTOM, -1);
		finishParam.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, -1);
		reLay.addView(finish, finishParam);
		// Matrix View
		mv = new MatrixView(ctx, res);
		mv.setId(2);
		RelativeLayout.LayoutParams mvParam = new RelativeLayout.LayoutParams(
				ViewGroup.LayoutParams.FILL_PARENT,
				ViewGroup.LayoutParams.FILL_PARENT);
		mvParam.addRule(RelativeLayout.BELOW, 1);
		mvParam.addRule(RelativeLayout.ABOVE, 3);
		reLay.addView(mv, mvParam);

		reset.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				mv.reset();
			}
		});
		finish.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				result[0] = mv.finish();
			}
		});

		return reLay;
	}

	@Override
	protected void onClose() {
		sendResult(result);
		super.onClose();
	}
}
